package com.xebialabs.deployit.plumbing;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.springframework.stereotype.Component;
import com.google.common.annotations.VisibleForTesting;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.xlrelease.domain.TaskDefinition;
import com.xebialabs.xlrelease.domain.TaskWithPropertiesDefinition;
import com.xebialabs.xltype.serialization.json.JsonWriter;

import static java.nio.charset.StandardCharsets.UTF_8;

@Component
@Provider
@Produces({MediaType.APPLICATION_JSON})
public class TaskDefinitionJsonWriter implements MessageBodyWriter<TaskDefinition> {
    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    @Override
    public long getSize(TaskDefinition object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(TaskDefinition object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(toJson(object).getBytes(UTF_8));
    }

    @VisibleForTesting
    String toJson(TaskDefinition object) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter(stringWriter);
        writeObject(writer, object);
        return stringWriter.toString();
    }

    static void writeObject(JsonWriter writer, TaskDefinition object) {
        writer.object();

        writer.key("typeName").value(object.getTypeName());
        writer.key("displayGroup").value(object.getDisplayGroup());
        writer.key("displayName").value(object.getDisplayName());
        writer.key("isAllowed").value(object.isAllowed());
        writer.key("isSupportedInWorkflow").value(object.isSupportedInWorkflow());

        if (object instanceof TaskWithPropertiesDefinition){
            TaskWithPropertiesDefinition taskWithPropertiesDefinition = (TaskWithPropertiesDefinition) object;
            writeProperties(writer, "inputProperties", taskWithPropertiesDefinition.getInputProperties()
                    .stream()
                    .filter(p -> !p.isHidden())
                    .collect(Collectors.toList()));
            writeProperties(writer, "outputProperties", taskWithPropertiesDefinition.getOutputProperties());
        }
        writer.endObject();
    }

    private static void writeProperties(JsonWriter writer, String jsonKey, Collection<PropertyDescriptor> properties) {
        writer.key(jsonKey);
        writer.array();
        for (PropertyDescriptor propertyDescriptor : properties) {
            PropertyDescriptorJsonWriter.writePropertyDescriptor(writer, propertyDescriptor);
        }
        writer.endArray();
    }
}
