/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service.blackout;

import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.actors.ExceptionTranslate;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActor;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.actors.extension.ActorExtensionHandlerFactory;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.blackout.BlackoutPeriod;
import com.xebialabs.xlrelease.domain.events.BlackoutDeletedEvent;
import com.xebialabs.xlrelease.domain.events.BlackoutUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.blackout.BlackoutReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.service.blackout.BlackoutTaskEventHandler$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

@Service
@ScalaSignature(bytes="\u0006\u0005\t]b\u0001B\u000b\u0017\u0001\u0005B\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!\u000f\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005u!A1\t\u0001BC\u0002\u0013\u0005A\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003F\u0011!a\u0005A!b\u0001\n\u0003i\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0011M\u0003!Q1A\u0005\u0002QC\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I!\u0016\u0005\u00069\u0002!\t!\u0018\u0005\u0006I\u0002!\t!\u001a\u0005\u0006e\u0002!\t!\u001a\u0005\u0006o\u0002!\t\u0001\u001f\u0005\b\u0003C\u0001A\u0011AA\u0012\u0011\u001d\t\t\u0004\u0001C\u0005\u0003gAq!!\u0015\u0001\t\u0013\t\u0019\u0006C\u0004\u0002\u0012\u0002!\t%a%\t\u000f\u0005E\u0007\u0001\"\u0003\u0002T\"9\u0011\u0011\u001e\u0001\u0005\n\u0005-\bbBA{\u0001\u0011%\u0011q\u001f\u0005\b\u0003w\u0004A\u0011IA\u007f\u0005a\u0011E.Y2l_V$H+Y:l\u000bZ,g\u000e\u001e%b]\u0012dWM\u001d\u0006\u0003/a\t\u0001B\u00197bG.|W\u000f\u001e\u0006\u00033i\tqa]3sm&\u001cWM\u0003\u0002\u001c9\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003;y\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003}\t1aY8n\u0007\u0001\u0019B\u0001\u0001\u0012)aA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\u0004\"!\u000b\u0018\u000e\u0003)R!a\u000b\u0017\u0002\u0013\u0015DH/\u001a8tS>t'BA\u0017\u001b\u0003\u0019\t7\r^8sg&\u0011qF\u000b\u0002\u001d\u0003\u000e$xN]#yi\u0016t7/[8o\u0011\u0006tG\r\\3s\r\u0006\u001cGo\u001c:z!\t\td'D\u00013\u0015\t\u0019D'A\u0003tY\u001a$$NC\u00016\u0003!9'/\u001b>{Y\u0016$\u0017BA\u001c3\u0005\u001daunZ4j]\u001e\f1\"Y2u_J\u001c\u0016p\u001d;f[V\t!\b\u0005\u0002<\u00016\tAH\u0003\u0002>}\u0005)\u0011m\u0019;pe*\tq(\u0001\u0003bW.\f\u0017BA!=\u0005-\t5\r^8s'f\u001cH/Z7\u0002\u0019\u0005\u001cGo\u001c:TsN$X-\u001c\u0011\u0002\u0011\u00154XM\u001c;CkN,\u0012!\u0012\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011j\ta!\u001a<f]R\u001c\u0018B\u0001&H\u0005!)e/\u001a8u\u0005V\u001c\u0018!C3wK:$()^:!\u0003M\u0011X\r\\3bg\u0016\f5\r^8s'\u0016\u0014h/[2f+\u0005q\u0005CA(Q\u001b\u0005a\u0013BA)-\u0005M\u0011V\r\\3bg\u0016\f5\r^8s'\u0016\u0014h/[2f\u0003Q\u0011X\r\\3bg\u0016\f5\r^8s'\u0016\u0014h/[2fA\u0005qA/Y:l%\u0016\u0004xn]5u_JLX#A+\u0011\u0005YKV\"A,\u000b\u0005aS\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011!l\u0016\u0002\u000f)\u0006\u001c8NU3q_NLGo\u001c:z\u0003=!\u0018m]6SKB|7/\u001b;pef\u0004\u0013A\u0002\u001fj]&$h\bF\u0003_A\u0006\u00147\r\u0005\u0002`\u00015\ta\u0003C\u00039\u0013\u0001\u0007!\bC\u0003D\u0013\u0001\u0007Q\tC\u0003M\u0013\u0001\u0007a\nC\u0003T\u0013\u0001\u0007Q+\u0001\u0005sK\u001eL7\u000f^3s)\u00051\u0007CA\u0012h\u0013\tAGE\u0001\u0003V]&$\bF\u0001\u0006k!\tY\u0007/D\u0001m\u0015\tig.\u0001\u0006b]:|G/\u0019;j_:T\u0011a\\\u0001\u0006U\u00064\u0018\r_\u0005\u0003c2\u0014Q\u0002U8ti\u000e{gn\u001d;sk\u000e$\u0018AC;oe\u0016<\u0017n\u001d;fe\"\u00121\u0002\u001e\t\u0003WVL!A\u001e7\u0003\u0015A\u0013X\rR3tiJ|\u00170A\tp]\nc\u0017mY6pkR,\u0006\u000fZ1uK\u0012$\"AZ=\t\u000bid\u0001\u0019A>\u0002\u000b\u00154XM\u001c;\u0011\u0007q\f\t!D\u0001~\u0015\tAeP\u0003\u0002\u00005\u00051Am\\7bS:L1!a\u0001~\u0005Q\u0011E.Y2l_V$X\u000b\u001d3bi\u0016$WI^3oi\"\u001aA\"a\u0002\u0011\t\u0005%\u0011QC\u0007\u0003\u0003\u0017Q1!\\A\u0007\u0015\u0011\ty!!\u0005\u0002\u000f5,GO]5dg*\u0019\u00111\u0003\u0010\u0002\u0011\r|G-\u00195bY\u0016LA!a\u0006\u0002\f\t)A+[7fI\"\u001aA\"a\u0007\u0011\u0007\u0019\u000bi\"C\u0002\u0002 \u001d\u0013\u0011bU;cg\u000e\u0014\u0018NY3\u0002#=t'\t\\1dW>,H\u000fR3mKR,G\rF\u0002g\u0003KAaA_\u0007A\u0002\u0005\u001d\u0002c\u0001?\u0002*%\u0019\u00111F?\u0003)\tc\u0017mY6pkR$U\r\\3uK\u0012,e/\u001a8uQ\ri\u0011q\u0001\u0015\u0004\u001b\u0005m\u0011\u0001E5t\u0003\u001a4Wm\u0019;j]\u001e$\u0016m]6t)\u0019\t)$a\u000f\u0002>A\u00191%a\u000e\n\u0007\u0005eBEA\u0004C_>dW-\u00198\t\u000bit\u0001\u0019A>\t\u000f\u0005}b\u00021\u0001\u0002B\u0005\u0019an\\<\u0011\t\u0005\r\u0013QJ\u0007\u0003\u0003\u000bRA!a\u0012\u0002J\u0005!Q\u000f^5m\u0015\t\tY%\u0001\u0003kCZ\f\u0017\u0002BA(\u0003\u000b\u0012A\u0001R1uK\u0006\u00112o\u00195fIVdW\rV1tWV\u0003H-\u0019;f)\u00151\u0017QKA8\u0011\u001d\t9f\u0004a\u0001\u00033\na\u0001^1tW&#\u0007\u0003BA.\u0003SrA!!\u0018\u0002fA\u0019\u0011q\f\u0013\u000e\u0005\u0005\u0005$bAA2A\u00051AH]8pizJ1!a\u001a%\u0003\u0019\u0001&/\u001a3fM&!\u00111NA7\u0005\u0019\u0019FO]5oO*\u0019\u0011q\r\u0013\t\u000f\u0005Et\u00021\u0001\u0002t\u000591m\\7nC:$\u0007\u0003BA;\u0003\u0017sA!a\u001e\u0002\b:!\u0011\u0011PAC\u001d\u0011\tY(a!\u000f\t\u0005u\u0014\u0011\u0011\b\u0005\u0003?\ny(C\u0001 \u0013\tib$\u0003\u0002\u001c9%\u0011QFG\u0005\u0004\u0003\u0013c\u0013!\b*fY\u0016\f7/Z#yK\u000e,H/[8o\u0003\u000e$xN]'fgN\fw-Z:\n\t\u00055\u0015q\u0012\u0002\u0011\u000bb$XM\\:j_:\u001cu.\\7b]\u0012T1!!#-\u0003)9W\r\u001e%b]\u0012dWM\u001d\u000b\t\u0003+\u000bY+!.\u0002@B!\u0011qSAS\u001d\u0011\tI*!)\u000f\t\u0005m\u0015q\u0014\b\u0005\u0003?\ni*C\u0001@\u0013\tid(C\u0002\u0002$r\nQ!Q2u_JLA!a*\u0002*\n9!+Z2fSZ,'bAARy!9\u0011Q\u0016\tA\u0002\u0005=\u0016\u0001B:fY\u001a\u00042aOAY\u0013\r\t\u0019\f\u0010\u0002\t\u0003\u000e$xN\u001d*fM\"9\u0011q\u0017\tA\u0002\u0005e\u0016AB:f]\u0012,'\u000fE\u0003$\u0003w\u000by+C\u0002\u0002>\u0012\u0012\u0011BR;oGRLwN\u001c\u0019\t\u0011\u0005\u0005\u0007\u0003\"a\u0001\u0003\u0007\fqA]3mK\u0006\u001cX\rE\u0003$\u0003\u000b\fI-C\u0002\u0002H\u0012\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0005\u0003\u0017\fi-D\u0001\u007f\u0013\r\tyM \u0002\b%\u0016dW-Y:f\u00039)\b\u000fZ1uKR\u000b7o[,ji\"$B!!6\u0002hR\u0019a-a6\t\u000f\u0005e\u0017\u00031\u0001\u0002\\\u00069Q\u000f\u001d3bi\u0016\u0014\bCB\u0012\u0002^\u0006\u0005h-C\u0002\u0002`\u0012\u0012\u0011BR;oGRLwN\\\u0019\u0011\t\u0005-\u00171]\u0005\u0004\u0003Kt(\u0001\u0002+bg.Dq!a\u0016\u0012\u0001\u0004\tI&\u0001\rva\u0012\fG/Z*dQ\u0016$W\u000f\\3e'R\f'\u000f\u001e#bi\u0016$RAZAw\u0003cDq!a<\u0013\u0001\u0004\t\t/\u0001\u0003uCN\\\u0007bBAz%\u0001\u0007\u0011\u0011I\u0001\u0016]\u0016<8k\u00195fIVdW\rZ*uCJ$H)\u0019;f\u0003]\u0011Xm]3u'\u000eDW\rZ;mK\u0012\u001cF/\u0019:u\t\u0006$X\rF\u0002g\u0003sDq!a<\u0014\u0001\u0004\t\t/\u0001\u0005tkB\u0004xN\u001d;t)\u0011\t)$a@\t\u000f\t\u0005A\u00031\u0001\u0003\u0004\u0005)1\r\\1{uB\"!Q\u0001B\b!\u0019\tYFa\u0002\u0003\f%!!\u0011BA7\u0005\u0015\u0019E.Y:t!\u0011\u0011iAa\u0004\r\u0001\u0011a!\u0011CA\u0000\u0003\u0003\u0005\tQ!\u0001\u0003\u0014\t\u0019q\fJ\u0019\u0012\t\tU!1\u0004\t\u0004G\t]\u0011b\u0001B\rI\t9aj\u001c;iS:<\u0007cA\u001e\u0003\u001e%\u0019!q\u0004\u001f\u0003\u000b\u0005\u001bGo\u001c:)\u0007\u0001\u0011\u0019\u0003\u0005\u0003\u0003&\tMRB\u0001B\u0014\u0015\u0011\u0011ICa\u000b\u0002\u0015M$XM]3pif\u0004XM\u0003\u0003\u0003.\t=\u0012aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\tE\u0012aA8sO&!!Q\u0007B\u0014\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class BlackoutTaskEventHandler
implements ActorExtensionHandlerFactory,
Logging {
    private final ActorSystem actorSystem;
    private final EventBus eventBus;
    private final ReleaseActorService releaseActorService;
    private final TaskRepository taskRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public <T> void replyOrFail(Function0<ActorRef> sender, Function0<T> call) {
        ActorExtensionHandlerFactory.replyOrFail$(this, sender, call);
    }

    @Override
    public Throwable translate(Throwable ex) {
        return ExceptionTranslate.translate$(this, ex);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        BlackoutTaskEventHandler blackoutTaskEventHandler = this;
        synchronized (blackoutTaskEventHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public ReleaseActorService releaseActorService() {
        return this.releaseActorService;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    @PostConstruct
    public void register() {
        this.eventBus().register((Object)this);
        this.logger().debug((Function0 & Serializable)() -> "Blackout task event handler registered in event bus.");
    }

    @PreDestroy
    public void unregister() {
        this.eventBus().deregister((Object)this);
        this.logger().debug((Function0 & Serializable)() -> "Blackout task event handler de-registered from event bus.");
    }

    @Subscribe
    @Timed
    public void onBlackoutUpdated(BlackoutUpdatedEvent event) {
        Date now = new Date();
        if (this.isAffectingTasks(event, now)) {
            Buffer taskIds = CollectionConverters$.MODULE$.ListHasAsScala(this.taskRepository().findAffectedByBlackout(event.original())).asScala();
            this.logger().debug((Function0 & Serializable)() -> taskIds.length() + " taskIds to be updated after blackout " + event.original().getLabel() + " update.");
            BlackoutMetadata metadata = BlackoutMetadata$.MODULE$.apply((Seq)new .colon.colon((Object)new BlackoutPeriod(event.updated().getStartDate(), event.updated().getEndDate()), (List)Nil$.MODULE$));
            boolean isInBlackout = metadata.isInBlackout(now);
            Date newScheduledStartDate = metadata.getEndOfBlackout(now);
            taskIds.foreach((Function1 & Serializable)taskId -> {
                this.scheduleTaskUpdate(taskId, isInBlackout ? new BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate(taskId, newScheduledStartDate) : new BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate(taskId));
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Subscribe
    @Timed
    public void onBlackoutDeleted(BlackoutDeletedEvent event) {
        Buffer taskIds = CollectionConverters$.MODULE$.ListHasAsScala(this.taskRepository().findAffectedByBlackout(event.blackout())).asScala();
        this.logger().debug((Function0 & Serializable)() -> taskIds.length() + " taskIds to be started after blackout " + event.blackout().getLabel() + " removal.");
        taskIds.foreach((Function1 & Serializable)taskId -> {
            this.scheduleTaskUpdate(taskId, new BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate(taskId));
            return BoxedUnit.UNIT;
        });
    }

    private boolean isAffectingTasks(BlackoutUpdatedEvent event, Date now) {
        Date date = event.original().getEndDate();
        Date date2 = event.updated().getEndDate();
        boolean endDateChanged = date == null ? date2 != null : !((Object)date).equals(date2);
        boolean startDateMovedIntoFuture = now.after(event.original().getStartDate()) && now.before(event.updated().getStartDate());
        return endDateChanged || startDateMovedIntoFuture;
    }

    private void scheduleTaskUpdate(String taskId, ReleaseExecutionActorMessages.ExtensionCommand command) {
        this.releaseActorService().executeCommandAsync(taskId, command);
    }

    @Override
    public PartialFunction<Object, BoxedUnit> getHandler(ActorRef self, Function0<ActorRef> sender, Function0<Release> release) {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ BlackoutTaskEventHandler $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate) {
                    BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate updateScheduledStartDate = (BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate)A1;
                    String taskId = updateScheduledStartDate.taskId();
                    Date newScheduledStartDate = updateScheduledStartDate.newScheduledStartDate();
                    this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateTaskWith(taskId, (Function1<Task, BoxedUnit>)(Function1 & Serializable)x$1 -> {
                        $anonfun$getHandler$1.$anonfun$applyOrElse$1(this, newScheduledStartDate, x$1);
                        return BoxedUnit.UNIT;
                    });
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate) {
                    BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate resetScheduledStartDate = (BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate)A1;
                    String taskId = resetScheduledStartDate.taskId();
                    this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateTaskWith(taskId, (Function1<Task, BoxedUnit>)(Function1 & Serializable)task -> {
                        $anonfun$getHandler$1.$anonfun$applyOrElse$2(this, task);
                        return BoxedUnit.UNIT;
                    });
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (object instanceof BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate) {
                    return true;
                }
                return object instanceof BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$1($anonfun$getHandler$1 $this, Date newScheduledStartDate$2, Task x$1) {
                $this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateScheduledStartDate(x$1, newScheduledStartDate$2);
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$2($anonfun$getHandler$1 $this, Task task) {
                $this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$resetScheduledStartDate(task);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(com.xebialabs.xlrelease.service.blackout.BlackoutTaskEventHandler$$anonfun$getHandler$1 java.util.Date com.xebialabs.xlrelease.domain.Task ), $anonfun$applyOrElse$2$adapted(com.xebialabs.xlrelease.service.blackout.BlackoutTaskEventHandler$$anonfun$getHandler$1 com.xebialabs.xlrelease.domain.Task )}, serializedLambda);
            }
        };
    }

    public void com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateTaskWith(String taskId, Function1<Task, BoxedUnit> updater) {
        Object task = this.taskRepository().findById(taskId);
        Task original = (Task)CiCloneHelper.cloneCi(task);
        updater.apply(task);
        this.taskRepository().update((Task)task);
        this.eventBus().publish((XLReleaseEvent)new TaskUpdatedEvent(original, task));
    }

    public void com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateScheduledStartDate(Task task, Date newScheduledStartDate) {
        this.logger().debug((Function0 & Serializable)() -> "Updating task '" + task.getId() + "' scheduled start date due to new blackout end date '" + newScheduledStartDate + "'");
        Date originalScheduledStartDate = task.getOriginalScheduledStartDate();
        task.setScheduledStartDate(newScheduledStartDate);
        task.setPostponedDueToBlackout(true);
        task.setOriginalScheduledStartDate(originalScheduledStartDate);
    }

    public void com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$resetScheduledStartDate(Task task) {
        this.logger().debug((Function0 & Serializable)() -> "Resetting task '" + task.getId() + "' scheduled start date due to blackout not being applicable anymore.");
        task.setScheduledStartDate(task.getOriginalScheduledStartDate());
        task.setPostponedDueToBlackout(false);
    }

    @Override
    public boolean supports(Class<? extends Actor> clazz) {
        return ReleaseExecutionActor.class.isAssignableFrom(clazz);
    }

    public BlackoutTaskEventHandler(ActorSystem actorSystem, EventBus eventBus, ReleaseActorService releaseActorService, TaskRepository taskRepository) {
        this.actorSystem = actorSystem;
        this.eventBus = eventBus;
        this.releaseActorService = releaseActorService;
        this.taskRepository = taskRepository;
        ExceptionTranslate.$init$(this);
        ActorExtensionHandlerFactory.$init$(this);
        Logging.$init$((Logging)this);
    }
}

