/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.xebialabs.deployit.Exceptions;
import com.xebialabs.deployit.Sanitizer;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.core.rest.resteasy.PathInterceptor;
import com.xebialabs.xlrelease.actors.RemoteException;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Provider
@Component
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005b\u0001\u0002\b\u0010\u0001aA\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\u0006u\u0001!\ta\u000f\u0005\n\u007f\u0001\u0001\r\u00111A\u0005\n\u0001C\u0011\"\u0013\u0001A\u0002\u0003\u0007I\u0011\u0002&\t\u0013M\u0003\u0001\u0019!A!B\u0013\t\u0005bB.\u0001\u0005\u0004%I\u0001\u0018\u0005\u0007K\u0002\u0001\u000b\u0011B/\t\u000f\u0019\u0004!\u0019!C\u0005O\"11\u000e\u0001Q\u0001\n!DQ\u0001\u001c\u0001\u0005\u00025DQ\u0001\u001f\u0001\u0005BeDQA \u0001\u0005\n}Dq!a\u0001\u0001\t\u0013\t)AA\u000bSK6|G/Z#yG\u0016\u0004H/[8o\u001b\u0006\u0004\b/\u001a:\u000b\u0005A\t\u0012\u0001\u00039mk6\u0014\u0017N\\4\u000b\u0005I\u0019\u0012\u0001\u00033fa2|\u00170\u001b;\u000b\u0005Q)\u0012!\u0003=fE&\fG.\u00192t\u0015\u00051\u0012aA2p[\u000e\u00011c\u0001\u0001\u001aCA\u0011!dH\u0007\u00027)\u0011A$H\u0001\u0005Y\u0006twMC\u0001\u001f\u0003\u0011Q\u0017M^1\n\u0005\u0001Z\"AB(cU\u0016\u001cG\u000fE\u0002#W5j\u0011a\t\u0006\u0003I\u0015\n1!\u001a=u\u0015\t1s%\u0001\u0002sg*\u0011\u0001&K\u0001\u0003oNT\u0011AK\u0001\u0006U\u00064\u0018\r_\u0005\u0003Y\r\u0012q\"\u0012=dKB$\u0018n\u001c8NCB\u0004XM\u001d\t\u0003]Mj\u0011a\f\u0006\u0003aE\na!Y2u_J\u001c(B\u0001\u001a\u0014\u0003%AHN]3mK\u0006\u001cX-\u0003\u00025_\ty!+Z7pi\u0016,\u0005pY3qi&|g.A\ntKJ4XM]\"p]\u001aLw-\u001e:bi&|g\u000e\u0005\u00028q5\t\u0011#\u0003\u0002:#\t\u00192+\u001a:wKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u00061A(\u001b8jiz\"\"\u0001\u0010 \u0011\u0005u\u0002Q\"A\b\t\u000bU\u0012\u0001\u0019\u0001\u001c\u0002\u000fI,\u0017/^3tiV\t\u0011\t\u0005\u0002C\u000f6\t1I\u0003\u0002E\u000b\u0006!\u0001\u000e\u001e;q\u0015\t1\u0015&A\u0004tKJ4H.\u001a;\n\u0005!\u001b%A\u0005%uiB\u001cVM\u001d<mKR\u0014V-];fgR\f1B]3rk\u0016\u001cHo\u0018\u0013fcR\u00111*\u0015\t\u0003\u0019>k\u0011!\u0014\u0006\u0002\u001d\u0006)1oY1mC&\u0011\u0001+\u0014\u0002\u0005+:LG\u000fC\u0004S\t\u0005\u0005\t\u0019A!\u0002\u0007a$\u0013'\u0001\u0005sKF,Xm\u001d;!Q\t)Q\u000b\u0005\u0002W36\tqK\u0003\u0002YK\u0005!1m\u001c:f\u0013\tQvKA\u0004D_:$X\r\u001f;\u0002\r1|wmZ3s+\u0005i\u0006C\u00010d\u001b\u0005y&B\u00011b\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\u0011\u0017aA8sO&\u0011Am\u0018\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005i\u0001.\u001b3f\u0013:$XM\u001d8bYN,\u0012\u0001\u001b\t\u0003\u0019&L!A['\u0003\u000f\t{w\u000e\\3b]\u0006q\u0001.\u001b3f\u0013:$XM\u001d8bYN\u0004\u0013AC4fi\u000e{g\u000e^3oiR\u0019a.\u001d<\u0011\u0005iy\u0017B\u00019\u001c\u0005\u0019\u0019FO]5oO\")!O\u0003a\u0001g\u0006IQ.\u001a3jCRK\b/\u001a\t\u0003-RL!!^,\u0003\u00135+G-[1UsB,\u0007\"B<\u000b\u0001\u0004i\u0013!C3yG\u0016\u0004H/[8o\u0003)!xNU3ta>t7/\u001a\u000b\u0003uv\u0004\"AV>\n\u0005q<&\u0001\u0003*fgB|gn]3\t\u000b]\\\u0001\u0019A\u0017\u0002\u001b!\fg\u000e\u001a7f\u0019><w-\u001b8h)\rY\u0015\u0011\u0001\u0005\u0006o2\u0001\r!L\u0001\u001dI\u0016$XM]7j]\u0016\f5mY3qi\u0006\u0014G.Z'fI&\fG+\u001f9f)\u0005\u0019\bf\u0001\u0001\u0002\nA!\u00111BA\u000b\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011AC:uKJ,w\u000e^=qK*\u0019\u00111C1\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.LA!a\u0006\u0002\u000e\tI1i\\7q_:,g\u000e\u001e\u0015\u0004\u0001\u0005m\u0001c\u0001\u0012\u0002\u001e%\u0019\u0011qD\u0012\u0003\u0011A\u0013xN^5eKJ\u0004")
public class RemoteExceptionMapper
implements ExceptionMapper<RemoteException> {
    @Context
    private HttpServletRequest request;
    private final Logger logger = LoggerFactory.getLogger(RemoteExceptionMapper.class);
    private final boolean hideInternals;

    private HttpServletRequest request() {
        return this.request;
    }

    private void request_$eq(HttpServletRequest x$1) {
        this.request = x$1;
    }

    private Logger logger() {
        return this.logger;
    }

    private boolean hideInternals() {
        return this.hideInternals;
    }

    public String getContent(MediaType mediaType, RemoteException exception) {
        String rawContent = Exceptions.getAllMessages((Exception)exception);
        MediaType mediaType2 = mediaType;
        if (mediaType2.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            return "{ \"content\": \"" + rawContent.replace("\"", "'") + "\" }";
        }
        if (mediaType2.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
            return "<![CDATA[" + rawContent.replace("]]>", "___") + "]]>";
        }
        return rawContent;
    }

    public Response toResponse(RemoteException exception) {
        this.handleLogging(exception);
        int responseStatusCode = exception.getResponseStatusCode();
        MediaType mediaType = this.determineAcceptableMediaType();
        String content = this.getContent(mediaType, exception);
        if (this.hideInternals()) {
            UUID uuid = UUID.randomUUID();
            this.logger().error("[UUID={}] Exception: {}", (Object)uuid, (Object)exception.getClass().getName());
            this.logger().error("[UUID={}] Error messages: {}", (Object)uuid, (Object)content);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)("An internal error has occurred, please notify your system administrator with the following code: " + uuid)).build();
        }
        Response.ResponseBuilder builder = Response.status((int)responseStatusCode).type(mediaType);
        builder.header("X-Exception-Type", (Object)exception.getClass().getName());
        builder.header("X-Remote-Exception", (Object)"true");
        builder.header("X-Path", PathInterceptor.PATH.get());
        builder.header("Date", (Object)new Date());
        builder.entity((Object)Sanitizer.sanitize((String)content));
        return builder.build();
    }

    private void handleLogging(RemoteException exception) {
        this.logger().info(exception.getMsg());
        String logMsg = "Intercepting RemoteException";
        if (exception.getSuppressStackTrace()) {
            this.logger().trace(logMsg, (Throwable)exception);
            return;
        }
        this.logger().info(logMsg, (Throwable)exception);
    }

    private MediaType determineAcceptableMediaType() {
        Enumeration accepted;
        Object object = this.request().getHeader("Accept-Type") != null ? new .colon.colon((Object)MediaType.valueOf((String)this.request().getHeader("Accept-Type")), (List)Nil$.MODULE$) : (this.request().getHeaders("Accept") != null ? ((accepted = this.request().getHeaders("Accept")) != null ? CollectionConverters$.MODULE$.EnumerationHasAsScala(accepted).asScala().flatMap((Function1 & Serializable)h -> Predef$.MODULE$.wrapRefArray((Object[])h.split(","))).map((Function1 & Serializable)e -> MediaType.valueOf((String)e.trim())).toList() : Nil$.MODULE$) : new .colon.colon((Object)MediaType.APPLICATION_XML_TYPE, (List)Nil$.MODULE$));
        .colon.colon mediaTypes = object;
        return (MediaType)mediaTypes.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MediaType.APPLICATION_JSON_TYPE.isCompatible(x$1))).getOrElse(() -> RemoteExceptionMapper.$anonfun$determineAcceptableMediaType$4((List)mediaTypes));
    }

    public static final /* synthetic */ MediaType $anonfun$determineAcceptableMediaType$4(List mediaTypes$1) {
        return (MediaType)mediaTypes$1.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MediaType.APPLICATION_XML_TYPE.isCompatible(x$1))).getOrElse((Function0 & Serializable)() -> MediaType.TEXT_PLAIN_TYPE);
    }

    public RemoteExceptionMapper(ServerConfiguration serverConfiguration) {
        this.hideInternals = serverConfiguration.isHideInternals();
    }
}

