/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.xlrelease.api.v1.filter.CategoryFilters;
import com.xebialabs.xlrelease.domain.Category;
import com.xebialabs.xlrelease.domain.events.CategoryCreatedEvent;
import com.xebialabs.xlrelease.domain.events.CategoryDeletedEvent;
import com.xebialabs.xlrelease.domain.events.CategoryUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.repository.CategoryRepository;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import org.slf4j.Marker;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005a\u0001\u0002\u0006\f\u0001QA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!)\u0011\u0007\u0001C\u0001e!)q\u0007\u0001C\u0001q!)a\r\u0001C\u0001O\")1\u000e\u0001C\u0001Y\")q\u000e\u0001C\u0001a\")!\u0010\u0001C\u0005w\")Q\u0010\u0001C\u0005}\ny1)\u0019;fO>\u0014\u0018pU3sm&\u001cWM\u0003\u0002\r\u001b\u000591/\u001a:wS\u000e,'B\u0001\b\u0010\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0011#\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002%\u0005\u00191m\\7\u0004\u0001M\u0019\u0001!F\u000e\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g!\ta\u0012%D\u0001\u001e\u0015\tqr$A\u0003tY\u001a$$NC\u0001!\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u0012\u001e\u0005\u001daunZ4j]\u001e\f!cY1uK\u001e|'/\u001f*fa>\u001c\u0018\u000e^8ssB\u0011Q\u0005K\u0007\u0002M)\u0011q%D\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u0015'\u0005I\u0019\u0015\r^3h_JL(+\u001a9pg&$xN]=\u0002\u0011\u00154XM\u001c;CkN\u0004\"\u0001L\u0018\u000e\u00035R!AL\u0007\u0002\r\u00154XM\u001c;t\u0013\t\u0001TF\u0001\u0005Fm\u0016tGOQ;t\u0003\u0019a\u0014N\\5u}Q\u00191'\u000e\u001c\u0011\u0005Q\u0002Q\"A\u0006\t\u000b\r\u001a\u0001\u0019\u0001\u0013\t\u000b)\u001a\u0001\u0019A\u0016\u0002\r\u0019Lg\u000e\u001a\"z)\rI$J\u0016\t\u0004u\r+U\"A\u001e\u000b\u0005qj\u0014A\u00023p[\u0006LgN\u0003\u0002?\u007f\u0005!A-\u0019;b\u0015\t\u0001\u0015)A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005\u0011\u0015aA8sO&\u0011Ai\u000f\u0002\u0005!\u0006<W\r\u0005\u0002G\u00116\tqI\u0003\u0002=\u001b%\u0011\u0011j\u0012\u0002\t\u0007\u0006$XmZ8ss\")1\n\u0002a\u0001\u0019\u0006y1-\u0019;fO>\u0014\u0018PR5mi\u0016\u00148\u000f\u0005\u0002N)6\taJ\u0003\u0002P!\u00061a-\u001b7uKJT!!\u0015*\u0002\u0005Y\f$BA*\u000e\u0003\r\t\u0007/[\u0005\u0003+:\u0013qbQ1uK\u001e|'/\u001f$jYR,'o\u001d\u0005\u0006/\u0012\u0001\r\u0001W\u0001\ta\u0006<W-\u00192mKB\u0011!(W\u0005\u00035n\u0012\u0001\u0002U1hK\u0006\u0014G.\u001a\u0015\u0003\tq\u0003\"!\u00183\u000e\u0003yS!a\u00181\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002bE\u00069Q.\u001a;sS\u000e\u001c(BA2\u0012\u0003!\u0019w\u000eZ1iC2,\u0017BA3_\u0005\u0015!\u0016.\\3e\u0003\u0019\u0019'/Z1uKR\u0011Q\t\u001b\u0005\u0006S\u0016\u0001\r!R\u0001\tG\u0006$XmZ8ss\"\u0012Q\u0001X\u0001\u0007kB$\u0017\r^3\u0015\u0005\u0015k\u0007\"B5\u0007\u0001\u0004)\u0005F\u0001\u0004]\u0003\u0019!W\r\\3uKR\u0011\u0011\u000f\u001e\t\u0003-IL!a]\f\u0003\tUs\u0017\u000e\u001e\u0005\u0006k\u001e\u0001\rA^\u0001\u0003S\u0012\u0004\"AF<\n\u0005a<\"aA%oi\"\u0012q\u0001X\u0001\u0017m\u0006d\u0017\u000eZ1uK\u0006sGMR5y\u0007\u0006$XmZ8ssR\u0011\u0011\u000f \u0005\u0006S\"\u0001\r!R\u0001\u0013G\",7m\u001b$pe\u0012+\b\u000f\\5dCR,7\u000f\u0006\u0002r\u007f\")\u0011.\u0003a\u0001\u000b\u0002")
public class CategoryService
implements Logging {
    private final CategoryRepository categoryRepository;
    private final EventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        CategoryService categoryService = this;
        synchronized (categoryService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public Page<Category> findBy(CategoryFilters categoryFilters, Pageable pageable) {
        return this.categoryRepository.findBy(categoryFilters, pageable);
    }

    @Timed
    public Category create(Category category) {
        category.setCiUid(null);
        this.validateAndFixCategory(category);
        this.checkForDuplicates(category);
        Category createdCategory = this.categoryRepository.create(category);
        this.eventBus.publish((XLReleaseEvent)new CategoryCreatedEvent(createdCategory));
        return createdCategory;
    }

    @Timed
    public Category update(Category category) {
        if (category.getCiUid() == null) {
            throw new IllegalArgumentException("The category ciUid must not be null or empty");
        }
        Option<Category> option = this.categoryRepository.findByCiUid(Predef$.MODULE$.Integer2int(category.getCiUid()));
        if (option instanceof Some) {
            Some some = (Some)option;
            Category originalCategory = (Category)some.value();
            this.validateAndFixCategory(category);
            String string = originalCategory.getTitle().toLowerCase();
            String string2 = category.getTitle().toLowerCase();
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.checkForDuplicates(category);
            }
            Category updatedCategory = this.categoryRepository.update(category);
            this.eventBus.publish((XLReleaseEvent)new CategoryUpdatedEvent(originalCategory, updatedCategory));
            return updatedCategory;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException("The category '" + category.getCiUid() + "' does not exist");
        }
        throw new MatchError(option);
    }

    @Timed
    public void delete(int id) {
        Option<Category> option = this.categoryRepository.findByCiUid(id);
        if (option instanceof Some) {
            Some some = (Some)option;
            Category category = (Category)some.value();
            this.categoryRepository.delete(id);
            this.eventBus.publish((XLReleaseEvent)new CategoryDeletedEvent(category));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    private void validateAndFixCategory(Category category) {
        String categoryStr = category.getTitle();
        if (!StringUtils.hasText((String)categoryStr)) {
            throw new IllegalArgumentException("The category title must not be null or empty");
        }
        categoryStr = Category.sanitizeTitle((String)categoryStr);
        category.setTitle(categoryStr);
        if (category.getActive() == null) {
            category.setActive(true);
            return;
        }
    }

    private void checkForDuplicates(Category category) {
        Option<Category> found = this.categoryRepository.findByTitle(category.getTitle());
        Option<Category> option = found;
        if (option instanceof Some) {
            Some some = (Some)option;
            Category existingCategory = (Category)some.value();
            Integer n = category.getCiUid();
            Integer n2 = existingCategory.getCiUid();
            if (n == null ? n2 != null : !((Object)n).equals(n2)) {
                throw new ItemAlreadyExistsException("The category '%s' already exists", new Object[]{category.getTitle()});
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public CategoryService(CategoryRepository categoryRepository, EventBus eventBus) {
        this.categoryRepository = categoryRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

