package com.xebialabs.xlrelease.views;

import java.util.*;
import org.joda.time.DateTime;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.deployit.plumbing.IgnoreArrayEmptyValues;
import com.xebialabs.xlrelease.domain.ReleaseKind;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdSerializer;
import com.xebialabs.xlrelease.serialization.json.jackson.PasswordDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.PasswordSerializer;

import static com.google.common.collect.Lists.newArrayList;

public class ReleaseForm {

    private ReleaseKind kind = ReleaseKind.RELEASE;

    @JsonSerialize(using = DomainIdSerializer.class)
    @JsonDeserialize(using = DomainIdDeserializer.class)
    private String templateId;

    private Date scheduledStartDate;
    private boolean autoStart;
    private Date dueDate;
    private String title;
    private String description;
    private UserView owner;
    private List<VariableView> variables = newArrayList();
    @JsonDeserialize(using = IgnoreArrayEmptyValues.class)
    private List<String> tags;
    private Flag flag = new Flag(FlagStatus.OK);
    private boolean calendarPublished;
    private Long plannedDuration;
    private boolean abortOnFailure;
    private boolean archiveRelease = true;
    private boolean allowPasswordsInAllFields;
    private boolean disableNotifications;
    private boolean allowConcurrentReleaseFromTrigger;
    private UserView scriptUsername;
    @JsonSerialize(using = PasswordSerializer.class)
    @JsonDeserialize(using = PasswordDeserializer.class)
    private String scriptUserPassword;
    private String parentId;
    private String author;

    private Map<String, String> variableMapping = new HashMap<>();

    private Map<String, Object> syntheticProperties = new HashMap<>();

    @JsonDeserialize(using = IgnoreArrayEmptyValues.class)
    private Set<String> categories = new HashSet<>();

    public boolean hasValidDates() {
        if (scheduledStartDate != null && dueDate != null) {
            return new DateTime(scheduledStartDate).isBefore(new DateTime(dueDate));
        }

        return true;
    }

    public boolean isFromTemplate() {
        return null != templateId;
    }

    public ReleaseForm() {
    }

    public String getTemplateId() {
        return templateId;
    }

    public Date getScheduledStartDate() {
        return scheduledStartDate;
    }

    public boolean getAutoStart() {
        return autoStart;
    }

    public Date getDueDate() {
        return dueDate;
    }

    public String getTitle() {
        return title;
    }

    public boolean hasTitle() {
        return title != null && !title.isEmpty();
    }

    public String getDescription() {
        return description;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setScheduledStartDate(Date scheduledStartDate) {
        this.scheduledStartDate = scheduledStartDate;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public boolean hasOwner() {
        return owner != null;
    }

    public UserView getOwner() {
        return owner;
    }

    public String getOwnerUsername() {
        return hasOwner() ? getOwner().getUsername() : null;
    }

    public void setOwner(UserView owner) {
        this.owner = owner;
    }

    public List<VariableView> getVariables() {
        return variables;
    }

    public void setVariables(List<VariableView> variables) {
        this.variables = variables;
    }

    public List<String> getTags() {
        return tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public Flag getFlag() {
        return flag;
    }

    public void setFlag(Flag flag) {
        this.flag = flag;
    }

    public boolean isCalendarPublished() {
        return calendarPublished;
    }

    public void setCalendarPublished(boolean calendarPublished) {
        this.calendarPublished = calendarPublished;
    }

    public boolean isAbortOnFailure() {
        return abortOnFailure;
    }

    public void setAbortOnFailure(boolean abortOnFailure) {
        this.abortOnFailure = abortOnFailure;
    }


    public boolean isArchiveRelease() {
        return archiveRelease;
    }

    public void setArchiveRelease(boolean archiveRelease) {
        this.archiveRelease = archiveRelease;
    }

    public boolean isAllowPasswordsInAllFields() {
        return allowPasswordsInAllFields;
    }

    public void setAllowPasswordsInAllFields(final boolean allowPasswordsInAllFields) {
        this.allowPasswordsInAllFields = allowPasswordsInAllFields;
    }

    public boolean isDisableNotifications() {
        return disableNotifications;
    }

    public void setDisableNotifications(boolean disableNotifications) {
        this.disableNotifications = disableNotifications;
    }

    public Long getPlannedDuration() {
        return plannedDuration;
    }

    public void setPlannedDuration(Long plannedDuration) {
        this.plannedDuration = plannedDuration;
    }

    public boolean isAllowConcurrentReleaseFromTrigger() {
        return allowConcurrentReleaseFromTrigger;
    }

    public void setAllowConcurrentReleasesFromTrigger(boolean allowConcurrentReleasesFromTrigger) {
        this.allowConcurrentReleaseFromTrigger = allowConcurrentReleasesFromTrigger;
    }

    public UserView getScriptUsername() {
        return scriptUsername;
    }

    public void setScriptUsername(UserView scriptUsername) {
        this.scriptUsername = scriptUsername;
    }

    public String getScriptUserPassword() {
        return scriptUserPassword;
    }

    public void setScriptUserPassword(String scriptUserPassword) {
        this.scriptUserPassword = scriptUserPassword;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(final String parentId) {
        this.parentId = parentId;
    }

    public Map<String, Object> getSyntheticProperties() {
        return syntheticProperties;
    }

    public boolean hasProperty(String name) {
        return syntheticProperties.containsKey(name);
    }

    public Object getProperty(String name) {
        return syntheticProperties.get(name);
    }

    public void setSyntheticProperties(final Map<String, Object> syntheticProperties) {
        this.syntheticProperties = syntheticProperties;
    }

    public Map<String, String> getVariableMapping() {
        return variableMapping;
    }

    public void setVariableMapping(Map<String, String> variableMapping) {
        this.variableMapping = variableMapping;
    }

    public ReleaseKind getKind() {
        return kind;
    }

    public void setKind(final ReleaseKind kind) {
        this.kind = kind;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(final String author) {
        this.author = author;
    }

    public Set<String> getCategories() {
        return categories;
    }

    public void setCategories(Set<String> categories) {
        this.categories = categories;
    }
}
