package com.xebialabs.xlrelease.script.jython

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.spring.configuration.ScriptingConfiguration
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class JythonScriptingConfiguration {

  @Bean
  def scriptingConfiguration(xlrConfig: XlrConfig): ScriptingConfiguration = {
    ScriptingConfiguration(
      policyAutoRefresh = xlrConfig.isAutoRefreshScriptPolicy,
      workDir = xlrConfig.repository.workDir,
      sandboxEnabled = xlrConfig.isScriptSandboxEnabled,
      xlrConfig.jythonSandboxConfiguration
    )
  }

  @Bean
  def jythonEngineEventHandler: JythonEngineEventHandler = new JythonEngineEventHandler()
}

