package com.xebialabs.xlrelease.scheduler.workers

import com.xebialabs.xlrelease.actors.ReleaseActorService
import com.xebialabs.xlrelease.script.TaskSoftReference
import com.xebialabs.xlrelease.user.User

trait TaskWorkerFailureLogic {
  def releaseActorService: ReleaseActorService

  def doRun(taskRef: TaskSoftReference[_])(block: => Unit): Unit = {
    try {
      block
    } catch {
      case e: Exception =>
        releaseActorService.failTaskWithRetry(taskRef.getTaskId, s"Unhandled exception: ${e.getMessage}", User.SYSTEM, None, taskRef.getExecutionId)
    }
  }
}
