package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.api.v1.filter.CategoryFilters
import com.xebialabs.xlrelease.domain.Category
import org.springframework.data.domain.{Page, Pageable}


trait CategoryRepository {
  def create(category: Category): Category

  def update(category: Category): Category

  def delete(id: Int): Unit

  def findByCiUid(id: Int): Option[Category]

  def findByTitle(title: String): Option[Category]

  def findByTitles(titles: Seq[String]): Seq[Category]

  def findBy(categoryFilters: CategoryFilters, pageable: Pageable): Page[Category]

  def findTitlesByReleaseCiUid(releaseUid: Int): Set[String]
}
