package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource
import com.xebialabs.xlrelease.domain.status.ReleaseStatus
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions

import java.util.{Date, List => JList, Set => JSet}
import scala.annotation.varargs

trait ReleaseRepository {
  def exists(id: String): Boolean

  def findById(id: String): Release

  def findById(id: String, resolveOptions: ResolveOptions): Release

  def create(release: Release, releaseCreationSource: ReleaseCreationSource): Release

  def delete(id: String): Unit = delete(id, failIfReferenced = true)

  def delete(id: String, failIfReferenced: Boolean): Unit

  def deleteWithUid(id: String, releaseUid: Int): Unit

  def move(originalId: String, newId: String): Unit

  @varargs
  def findIdsByStatus(statuses: ReleaseStatus*): Seq[String]

  def findByCalendarToken(calendarToken: String): Release

  def findArchivableReleaseIds(date: Date, pageSize: Int): Seq[String]

  def setPreArchived(releaseId: String, preArchived: Boolean): Unit

  def findPreArchivableReleases(page: Int, pageSize: Int): Seq[Release]

  def search(searchParams: ReleaseSearchByParams): JList[Release]

  def getUid(id: String): Option[Integer]

  def getStatus(id: String): ReleaseStatus

  def getStatuses(ids: Seq[String]): Seq[ReleaseStatus]

  def getStatusesWithIds(ids: Seq[String]): Seq[(String, ReleaseStatus)]

  def getRiskScores(ids: Seq[String]): Seq[Int]

  def setRiskScores(releaseId: String, score: Int, totalScore: Int): Unit

  def isTemplate(releaseId: String): Boolean

  def getTitle(id: String): String

  def update(release: Release): Release

  def update(original: Release, updated: Release): Release

  def replace(original: Release, updated: Release): Release

  def getAllTags(limitNumber: Int): JSet[String]

  def registerPersistenceInterceptor(persistenceInterceptor: PersistenceInterceptor[Release]): Unit

  def findSCMDataById(id: String): Option[Integer]

  def findOverdueReleaseIds(): Seq[String]

  def getReleaseJson(id: String): String

  def getFullId(releaseId: String): String

  def getReleasesWithoutComments(releaseIds: List[String]): List[Release]
}

