package com.xebialabs.deployit.plumbing;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;
import org.springframework.stereotype.Component;
import org.threeten.extra.Interval;

@Component
@Provider
public class IntervalParamConverterProvider implements ParamConverterProvider {

    @Override
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if(rawType.equals(Interval.class)){
            return (ParamConverter<T>) new IntervalParamConverter();
        }
        return null;
    }
}