/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.logs;

import akka.actor.ActorRef;
import com.xebialabs.xlrelease.domain.events.TaskJobExecutedEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.scheduler.events.JobFinishedEvent;
import com.xebialabs.xlrelease.scheduler.logs.ExecutionLogWatchActor;
import com.xebialabs.xlrelease.scheduler.logs.ExecutionLogWatcherSupervisor;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionEntry;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLog;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLogService$;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionRepository;
import com.xebialabs.xlrelease.scheduler.logs.TaskLogCreated;
import com.xebialabs.xlrelease.service.BroadcastService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.storage.domain.LogEntry;
import com.xebialabs.xlrelease.storage.domain.StorageEntry;
import com.xebialabs.xlrelease.storage.service.StorageService;
import com.xebialabs.xlrelease.support.akka.spring.SpringExtension;
import com.xebialabs.xlrelease.views.TaskExecutionLogView;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.time.Instant;
import java.util.List;
import javax.ws.rs.sse.SseEventSink;
import org.slf4j.Marker;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\tMa\u0001\u0002\u000b\u0016\u0001\u0001B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tu\u0001\u0011\t\u0011)A\u0005w!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011!i\u0005A!A!\u0002\u0013q\u0005\"\u0002*\u0001\t\u0003\u0019\u0006\u0002\u0003.\u0001\u0011\u000b\u0007I\u0011B.\t\u000b\r\u0004A\u0011\u00013\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e!9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0004bBA?\u0001\u0011\u0005\u0011q\u0010\u0005\b\u0003\u001f\u0003A\u0011AAI\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003KCq!a1\u0001\t\u0003\t)\rC\u0004\u0002T\u0002!\t!!6\b\u000f\t\u0015Q\u0003#\u0001\u0003\b\u00191A#\u0006E\u0001\u0005\u0013AaAU\t\u0005\u0002\t-\u0001b\u0002B\u0007#\u0011\u0005!q\u0002\u0002\u0018)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8M_\u001e\u001cVM\u001d<jG\u0016T!AF\f\u0002\t1|wm\u001d\u0006\u00031e\t\u0011b]2iK\u0012,H.\u001a:\u000b\u0005iY\u0012!\u0003=me\u0016dW-Y:f\u0015\taR$A\u0005yK\nL\u0017\r\\1cg*\ta$A\u0002d_6\u001c\u0001aE\u0002\u0001C\u001d\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0007C\u0001\u0015.\u001b\u0005I#B\u0001\u0016,\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005a\u0013\u0001C4sSjTH.\u001a3\n\u00059J#a\u0002'pO\u001eLgnZ\u0001\u0010gB\u0014\u0018N\\4FqR,gn]5p]B\u0011\u0011\u0007O\u0007\u0002e)\u00111\u0007N\u0001\u0007gB\u0014\u0018N\\4\u000b\u0005U2\u0014\u0001B1lW\u0006T!aN\r\u0002\u000fM,\b\u000f]8si&\u0011\u0011H\r\u0002\u0010'B\u0014\u0018N\\4FqR,gn]5p]\u0006\u0001\"M]8bI\u000e\f7\u000f^*feZL7-\u001a\t\u0003y}j\u0011!\u0010\u0006\u0003}e\tqa]3sm&\u001cW-\u0003\u0002A{\t\u0001\"I]8bI\u000e\f7\u000f^*feZL7-Z\u0001\u000fgR|'/Y4f'\u0016\u0014h/[2f!\t\u0019u)D\u0001E\u0015\tqTI\u0003\u0002G3\u000591\u000f^8sC\u001e,\u0017B\u0001%E\u00059\u0019Fo\u001c:bO\u0016\u001cVM\u001d<jG\u0016\f1\u0002^1tWN+'O^5dKB\u0011AhS\u0005\u0003\u0019v\u00121\u0002V1tWN+'O^5dK\u00069B/Y:l\u000bb,7-\u001e;j_:\u0014V\r]8tSR|'/\u001f\t\u0003\u001fBk\u0011!F\u0005\u0003#V\u0011q\u0003V1tW\u0016CXmY;uS>t'+\u001a9pg&$xN]=\u0002\rqJg.\u001b;?)\u0019!VKV,Y3B\u0011q\n\u0001\u0005\u0006_\u0019\u0001\r\u0001\r\u0005\u0006u\u0019\u0001\ra\u000f\u0005\u0006\u0003\u001a\u0001\rA\u0011\u0005\u0006\u0013\u001a\u0001\rA\u0013\u0005\u0006\u001b\u001a\u0001\rAT\u0001\u001cKb,7-\u001e;j_:dunZ,bi\u000eDWM]!di>\u0014(+\u001a4\u0016\u0003q\u0003\"!X1\u000e\u0003yS!a\u00181\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003UJ!A\u00190\u0003\u0011\u0005\u001bGo\u001c:SK\u001a\fQa^1uG\"$B!\u001a5voB\u0011!EZ\u0005\u0003O\u000e\u0012A!\u00168ji\")\u0011\u000e\u0003a\u0001U\u00061A/Y:l\u0013\u0012\u0004\"a\u001b:\u000f\u00051\u0004\bCA7$\u001b\u0005q'BA8 \u0003\u0019a$o\\8u}%\u0011\u0011oI\u0001\u0007!J,G-\u001a4\n\u0005M$(AB*ue&twM\u0003\u0002rG!)a\u000f\u0003a\u0001U\u0006YQ\r_3dkRLwN\\%e\u0011\u0015A\b\u00021\u0001z\u0003\u0011\u0019\u0018N\\6\u0011\u0007i\f9!D\u0001|\u0015\taX0A\u0002tg\u0016T!A`@\u0002\u0005I\u001c(\u0002BA\u0001\u0003\u0007\t!a^:\u000b\u0005\u0005\u0015\u0011!\u00026bm\u0006D\u0018bAA\u0005w\na1k]3Fm\u0016tGoU5oW\u0006)a-\u001a;dQRYQ-a\u0004\u0002\u0012\u0005M\u0011qEA+\u0011\u0015I\u0017\u00021\u0001k\u0011\u00151\u0018\u00021\u0001k\u0011\u001d\t)\"\u0003a\u0001\u0003/\tAb\\;uaV$8\u000b\u001e:fC6\u0004B!!\u0007\u0002$5\u0011\u00111\u0004\u0006\u0005\u0003;\ty\"\u0001\u0002j_*\u0011\u0011\u0011E\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002&\u0005m!\u0001D(viB,Ho\u0015;sK\u0006l\u0007bBA\u0015\u0013\u0001\u0007\u00111F\u0001\bY\u0006\u001cHOS8c!\u0011\ti#a\u0014\u000f\t\u0005=\u0012\u0011\n\b\u0005\u0003c\t\u0019E\u0004\u0003\u00024\u0005}b\u0002BA\u001b\u0003{qA!a\u000e\u0002<9\u0019Q.!\u000f\n\u0003yI!\u0001H\u000f\n\u0005iY\u0012bAA!3\u00051!/\u001e8oKJLA!!\u0012\u0002H\u00051Am\\7bS:T1!!\u0011\u001a\u0013\u0011\tY%!\u0014\u0002\u000fA\f7m[1hK*!\u0011QIA$\u0013\u0011\t\t&a\u0015\u0003\u000b){'-\u00133\u000b\t\u0005-\u0013Q\n\u0005\b\u0003/J\u0001\u0019AA-\u0003%a\u0017m\u001d;DQVt7\u000eE\u0002#\u00037J1!!\u0018$\u0005\u0011auN\\4\u0002%\u0019,Go\u00195BY2,\u00050Z2vi&|gn\u001d\u000b\u0005\u0003G\nY\b\u0005\u0004\u0002f\u0005-\u0014qN\u0007\u0003\u0003ORA!!\u001b\u0002 \u0005!Q\u000f^5m\u0013\u0011\ti'a\u001a\u0003\t1K7\u000f\u001e\t\u0005\u0003c\n9(\u0004\u0002\u0002t)\u0019\u0011QO\r\u0002\u000bYLWm^:\n\t\u0005e\u00141\u000f\u0002\u0015)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8M_\u001e4\u0016.Z<\t\u000b%T\u0001\u0019\u00016\u0002\u00071|w\rF\u0002f\u0003\u0003Cq!a!\f\u0001\u0004\t))\u0001\u0005m_\u001e,e\u000e\u001e:z!\u0011\t9)a#\u000e\u0005\u0005%%bAA#\u000b&!\u0011QRAE\u0005!aunZ#oiJL\u0018!F4fiR\u000b7o[#yK\u000e,H/[8o\u000b:$(/\u001f\u000b\u0007\u0003'\u000by*!)\u0011\u000b\t\n)*!'\n\u0007\u0005]5E\u0001\u0004PaRLwN\u001c\t\u0004\u001f\u0006m\u0015bAAO+\t\u0011B+Y:l\u000bb,7-\u001e;j_:,e\u000e\u001e:z\u0011\u0015IG\u00021\u0001k\u0011\u00151H\u00021\u0001k\u00035ygNS8c\r&t\u0017n\u001d5fIR\u0019Q-a*\t\u000f\u0005%V\u00021\u0001\u0002,\u0006)QM^3oiB!\u0011QVAZ\u001b\t\tyKC\u0002\u00022^\ta!\u001a<f]R\u001c\u0018\u0002BA[\u0003_\u0013\u0001CS8c\r&t\u0017n\u001d5fI\u00163XM\u001c;)\u00075\tI\f\u0005\u0003\u0002<\u0006}VBAA_\u0015\r\t\t,G\u0005\u0005\u0003\u0003\fiLA\u0005Tk\n\u001c8M]5cK\u0006\u0001rN\u001c+bg.dunZ\"sK\u0006$X\r\u001a\u000b\u0004K\u0006\u001d\u0007bBAe\u001d\u0001\u0007\u00111Z\u0001\ri\u0006\u001c8\u000eT8h\u000bZ,g\u000e\u001e\t\u0004\u001f\u00065\u0017bAAh+\tqA+Y:l\u0019><7I]3bi\u0016$\u0007f\u0001\b\u0002:\u0006\u0019rN\u001c+bg.,\u00050Z2vi&|g\u000eR8oKR\u0019Q-a6\t\u000f\u0005%v\u00021\u0001\u0002ZB!\u00111\\Aq\u001b\t\tiN\u0003\u0003\u00022\u0006}'bAA#3%!\u00111]Ao\u0005Q!\u0016m]6K_\n,\u00050Z2vi\u0016$WI^3oi\"\u001aq\"!/)\u0007\u0001\tI\u000f\u0005\u0003\u0002<\u0006-\u0018\u0002BAw\u0003{\u0013Q\"\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014\bf\u0001\u0001\u0002rB!\u00111\u001fB\u0001\u001b\t\t)P\u0003\u0003\u0002x\u0006e\u0018AC:uKJ,w\u000e^=qK*!\u00111`A\u007f\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAA\u0000\u0003\ry'oZ\u0005\u0005\u0005\u0007\t)PA\u0004TKJ4\u0018nY3\u0002/Q\u000b7o[#yK\u000e,H/[8o\u0019><7+\u001a:wS\u000e,\u0007CA(\u0012'\t\t\u0012\u0005\u0006\u0002\u0003\b\u0005!\u0001.Y:i)\rQ'\u0011\u0003\u0005\u0006SN\u0001\rA\u001b")
public class TaskExecutionLogService
implements Logging {
    private ActorRef executionLogWatcherActorRef;
    private final SpringExtension springExtension;
    private final BroadcastService broadcastService;
    private final StorageService storageService;
    private final TaskService taskService;
    private final TaskExecutionRepository taskExecutionRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static String hash(String taskId) {
        return TaskExecutionLogService$.MODULE$.hash(taskId);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TaskExecutionLogService taskExecutionLogService = this;
        synchronized (taskExecutionLogService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private ActorRef executionLogWatcherActorRef$lzycompute() {
        TaskExecutionLogService taskExecutionLogService = this;
        synchronized (taskExecutionLogService) {
            if (!this.bitmap$0) {
                this.executionLogWatcherActorRef = this.springExtension.actorOf(ExecutionLogWatcherSupervisor.class, "execution-log-watchers", this.springExtension.actorOf$default$3(), this.springExtension.actorOf$default$4());
                this.bitmap$0 = true;
            }
        }
        return this.executionLogWatcherActorRef;
    }

    private ActorRef executionLogWatcherActorRef() {
        if (!this.bitmap$0) {
            return this.executionLogWatcherActorRef$lzycompute();
        }
        return this.executionLogWatcherActorRef;
    }

    public void watch(String taskId, String executionId, SseEventSink sink) {
        ExecutionLogWatchActor.StartWatch x$1 = new ExecutionLogWatchActor.StartWatch(taskId, executionId, sink);
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    public void fetch(String taskId, String executionId, OutputStream outputStream, long lastJob, long lastChunk) {
        new TaskExecutionLog(taskId, executionId).fetch(this.storageService, outputStream, lastJob, lastChunk);
    }

    public List<TaskExecutionLogView> fetchAllExecutions(String taskId) {
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(this.taskExecutionRepository.find(new TaskExecutionRepository.ByTaskId(taskId), Pageable.unpaged()).getContent()).asScala().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long l;
                TaskExecutionEntry row = (TaskExecutionEntry)tuple2._1();
                int index = tuple2._2$mcI$sp();
                TaskExecutionLogView view = new TaskExecutionLogView();
                view.setId(row.executionId());
                view.setExecutionNo(Predef$.MODULE$.int2Integer(index + 1));
                view.setLastJob(Predef$.MODULE$.long2Long((long)row.lastJob()));
                view.setLastChunk(Predef$.MODULE$.int2Integer(row.lastChunk()));
                Option option = Option$.MODULE$.apply((Object)row.lastModifiedDate());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Instant date2 = (Instant)some.value();
                    l = date2.toEpochMilli();
                } else if (None$.MODULE$.equals(option)) {
                    l = Instant.now().toEpochMilli();
                } else {
                    throw new MatchError((Object)option);
                }
                long modifiedDate = l;
                view.setModifiedDate(Predef$.MODULE$.long2Long(modifiedDate));
                Option$.MODULE$.apply((Object)row.endDate()).foreach((Function1 & Serializable)date -> {
                    view.setEndDate(Predef$.MODULE$.long2Long(date.toEpochMilli()));
                    return BoxedUnit.UNIT;
                });
                return view;
            }
            throw new MatchError((Object)tuple2);
        })).asJava();
    }

    public void log(LogEntry logEntry) {
        String x$1 = "xlr-local";
        String x$2 = logEntry.copy$default$1();
        String x$3 = logEntry.copy$default$2();
        long x$4 = logEntry.copy$default$3();
        long x$5 = logEntry.copy$default$4();
        String x$6 = logEntry.copy$default$5();
        byte[] x$7 = logEntry.copy$default$6();
        LogEntry workerLogEntry = logEntry.copy(x$2, x$3, x$4, x$5, x$6, x$7, "xlr-local");
        URI storedEntryUri = this.storageService.store((StorageEntry)workerLogEntry);
        TaskStatus taskStatus = this.taskService.getStatus(logEntry.taskId());
        this.logger().info((Function0 & Serializable)() -> "Adding log entry with task status: " + taskStatus);
        Option<TaskExecutionEntry> option = taskStatus.isOneOf(new TaskStatus[]{TaskStatus.COMPLETED, TaskStatus.SKIPPED, TaskStatus.ABORTED, TaskStatus.FAILED, TaskStatus.FAILING, TaskStatus.ABORT_SCRIPT_IN_PROGRESS, TaskStatus.FAILURE_HANDLER_IN_PROGRESS}) ? this.taskExecutionRepository.update(new TaskExecutionRepository.UpdateWithLogEntry(workerLogEntry, (Option<Instant>)new Some((Object)Instant.now()))) : this.taskExecutionRepository.update(new TaskExecutionRepository.UpdateWithLogEntry(workerLogEntry, (Option<Instant>)None$.MODULE$));
        this.broadcastService.broadcast(new TaskLogCreated(logEntry.taskId(), logEntry.executionId(), storedEntryUri), true);
    }

    public Option<TaskExecutionEntry> getTaskExecutionEntry(String taskId, String executionId) {
        return this.taskExecutionRepository.read(taskId, executionId);
    }

    @Subscribe
    public void onJobFinished(JobFinishedEvent event) {
        long jobId = event.jobId();
        String executionId = event.executionId();
        this.logger().debug((Function0 & Serializable)() -> "finishing job " + jobId);
        ExecutionLogWatchActor.Check x$1 = new ExecutionLogWatchActor.Check(executionId);
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    @Subscribe
    public void onTaskLogCreated(TaskLogCreated taskLogEvent) {
        this.logger().debug((Function0 & Serializable)() -> "processing log event " + taskLogEvent);
        ExecutionLogWatchActor.NewEntry x$1 = new ExecutionLogWatchActor.NewEntry(taskLogEvent.executionId(), taskLogEvent.uri());
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    @Subscribe
    public void onTaskExecutionDone(TaskJobExecutedEvent event) {
        TaskExecutionRepository.FinishExecution finishExecution = new TaskExecutionRepository.FinishExecution(event.taskId(), event.executionId(), Instant.now());
        this.taskExecutionRepository.update(finishExecution);
    }

    public TaskExecutionLogService(SpringExtension springExtension, BroadcastService broadcastService, StorageService storageService, TaskService taskService, TaskExecutionRepository taskExecutionRepository) {
        this.springExtension = springExtension;
        this.broadcastService = broadcastService;
        this.storageService = storageService;
        this.taskService = taskService;
        this.taskExecutionRepository = taskExecutionRepository;
        Logging.$init$((Logging)this);
    }
}

