/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.logs;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.NoSerializationVerificationNeeded;
import akka.actor.ReceiveTimeout$;
import akka.actor.SupervisorStrategy;
import akka.annotation.InternalApi;
import akka.event.LoggingReceive$;
import akka.event.slf4j.SLF4JLogging;
import com.xebialabs.xlrelease.repository.SSERepository;
import com.xebialabs.xlrelease.scheduler.logs.ExecutionLogWatchActor$;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionEntry;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLogService;
import com.xebialabs.xlrelease.storage.domain.JobEntryRef;
import com.xebialabs.xlrelease.storage.domain.StorageEntryRef;
import com.xebialabs.xlrelease.storage.service.StorageService;
import com.xebialabs.xlrelease.support.akka.spring.SpringActor;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.time.Instant;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.SseEventSink;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Using;
import scala.util.Using$;

@SpringActor
@ScalaSignature(bytes="\u0006\u0005\u0011UaaBA\u0001\u0003\u0007\u0001\u0011\u0011\u0004\u0005\u000b\u0003\u000f\u0002!\u0011!Q\u0001\n\u0005%\u0003BCA)\u0001\t\u0005\t\u0015!\u0003\u0002T!Q\u00111\r\u0001\u0003\u0002\u0003\u0006I!!\u001a\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t!Y\u0011Q\u0010\u0001A\u0002\u0003\u0007I\u0011AA@\u0011-\t9\n\u0001a\u0001\u0002\u0004%\t!!'\t\u0017\u0005\u0015\u0006\u00011A\u0001B\u0003&\u0011\u0011\u0011\u0005\f\u0003O\u0003\u0001\u0019!a\u0001\n\u0003\ty\bC\u0006\u0002*\u0002\u0001\r\u00111A\u0005\u0002\u0005-\u0006bCAX\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0003C\u0011\"!-\u0001\u0001\u0004%\t!a-\t\u0013\u0005\u0015\u0007\u00011A\u0005\u0002\u0005\u001d\u0007\u0002CAf\u0001\u0001\u0006K!!.\t\u000f\u00055\u0007\u0001\"\u0011\u0002P\"9\u0011\u0011\u001c\u0001\u0005B\u0005m\u0007bBAo\u0001\u0011%\u0011q\u001c\u0005\b\u0007O\u0004A\u0011BBu\u0011\u001d\u0019)\u0010\u0001C\u0005\u0007oDqaa?\u0001\t\u0013\u0019ip\u0002\u0005\u0002~\u0006\r\u0001\u0012AA\u0000\r!\t\t!a\u0001\t\u0002\t\u0005\u0001bBA9+\u0011\u0005!1\u0001\u0005\n\u0005\u000b)\"\u0019!C\u0003\u0003\u007fB\u0001Ba\u0002\u0016A\u00035\u0011\u0011\u0011\u0005\n\u0005\u0013)\"\u0019!C\u0003\u0003\u007fB\u0001Ba\u0003\u0016A\u00035\u0011\u0011\u0011\u0005\n\u0005\u001b)\"\u0019!C\u0003\u0003\u007fB\u0001Ba\u0004\u0016A\u00035\u0011\u0011\u0011\u0004\n\u0005#)\u0002\u0013aI\u0011\u0005'Aq!! \u001e\r\u0003\tyH\u0002\u0004\u0003jV\u0001%1\u001e\u0005\u000b\u0003O{\"Q3A\u0005\u0002\u0005}\u0004BCAX?\tE\t\u0015!\u0003\u0002\u0002\"Q\u0011QP\u0010\u0003\u0016\u0004%\t!a \t\u0015\u0005\u0015vD!E!\u0002\u0013\t\t\t\u0003\u0006\u0003t~\u0011)\u001a!C\u0001\u0005kD!ba\u0004 \u0005#\u0005\u000b\u0011\u0002B|\u0011\u001d\t\th\bC\u0001\u0007#A\u0011B!\u0010 \u0003\u0003%\taa\u0007\t\u0013\t\rs$%A\u0005\u0002\t\u0015\u0003\"\u0003Bj?E\u0005I\u0011\u0001B#\u0011%\u0019\u0019cHI\u0001\n\u0003\u0019)\u0003C\u0005\u0003\\}\t\t\u0011\"\u0011\u0003^!I!\u0011N\u0010\u0002\u0002\u0013\u0005!1\u000e\u0005\n\u0005gz\u0012\u0011!C\u0001\u0007SA\u0011Ba  \u0003\u0003%\tE!!\t\u0013\t=u$!A\u0005\u0002\r5\u0002\"\u0003BN?\u0005\u0005I\u0011IB\u0019\u0011%\u0011\tkHA\u0001\n\u0003\u0012\u0019\u000bC\u0005\u0003&~\t\t\u0011\"\u0011\u0003(\"I!\u0011V\u0010\u0002\u0002\u0013\u00053QG\u0004\n\u0007/*\u0012\u0011!E\u0001\u000732\u0011B!;\u0016\u0003\u0003E\taa\u0017\t\u000f\u0005ET\u0007\"\u0001\u0004t!I!QU\u001b\u0002\u0002\u0013\u0015#q\u0015\u0005\n\u0007k*\u0014\u0011!CA\u0007oB\u0011ba 6\u0003\u0003%\ti!!\t\u0013\rMU'!A\u0005\n\rUeABB\u001d+\u0001\u001bY\u0004\u0003\u0006\u0002~m\u0012)\u001a!C\u0001\u0003\u007fB!\"!*<\u0005#\u0005\u000b\u0011BAA\u0011\u001d\t\th\u000fC\u0001\u0007{A\u0011B!\u0010<\u0003\u0003%\taa\u0011\t\u0013\t\r3(%A\u0005\u0002\t\u0015\u0003\"\u0003B.w\u0005\u0005I\u0011\tB/\u0011%\u0011IgOA\u0001\n\u0003\u0011Y\u0007C\u0005\u0003tm\n\t\u0011\"\u0001\u0004H!I!qP\u001e\u0002\u0002\u0013\u0005#\u0011\u0011\u0005\n\u0005\u001f[\u0014\u0011!C\u0001\u0007\u0017B\u0011Ba'<\u0003\u0003%\tea\u0014\t\u0013\t\u00056(!A\u0005B\t\r\u0006\"\u0003BSw\u0005\u0005I\u0011\tBT\u0011%\u0011IkOA\u0001\n\u0003\u001a\u0019fB\u0005\u0004\u001eV\t\t\u0011#\u0001\u0004 \u001aI1\u0011H\u000b\u0002\u0002#\u00051\u0011\u0015\u0005\b\u0003cZE\u0011ABU\u0011%\u0011)kSA\u0001\n\u000b\u00129\u000bC\u0005\u0004v-\u000b\t\u0011\"!\u0004,\"I1qP&\u0002\u0002\u0013\u00055q\u0016\u0005\n\u0007'[\u0015\u0011!C\u0005\u0007+3aAa\u0006\u0016\u0001\ne\u0001BCA?#\nU\r\u0011\"\u0001\u0002\u0000!Q\u0011QU)\u0003\u0012\u0003\u0006I!!!\t\u000f\u0005E\u0014\u000b\"\u0001\u00038!I!QH)\u0002\u0002\u0013\u0005!q\b\u0005\n\u0005\u0007\n\u0016\u0013!C\u0001\u0005\u000bB\u0011Ba\u0017R\u0003\u0003%\tE!\u0018\t\u0013\t%\u0014+!A\u0005\u0002\t-\u0004\"\u0003B:#\u0006\u0005I\u0011\u0001B;\u0011%\u0011y(UA\u0001\n\u0003\u0012\t\tC\u0005\u0003\u0010F\u000b\t\u0011\"\u0001\u0003\u0012\"I!1T)\u0002\u0002\u0013\u0005#Q\u0014\u0005\n\u0005C\u000b\u0016\u0011!C!\u0005GC\u0011B!*R\u0003\u0003%\tEa*\t\u0013\t%\u0016+!A\u0005B\t-v!CB[+\u0005\u0005\t\u0012AB\\\r%\u00119\"FA\u0001\u0012\u0003\u0019I\fC\u0004\u0002r\u0005$\ta!0\t\u0013\t\u0015\u0016-!A\u0005F\t\u001d\u0006\"CB;C\u0006\u0005I\u0011QB`\u0011%\u0019y(YA\u0001\n\u0003\u001b\u0019\rC\u0005\u0004\u0014\u0006\f\t\u0011\"\u0003\u0004\u0016\u001a1!qV\u000bA\u0005cC!\"! h\u0005+\u0007I\u0011AA@\u0011)\t)k\u001aB\tB\u0003%\u0011\u0011\u0011\u0005\u000b\u0005g;'Q3A\u0005\u0002\tU\u0006B\u0003BbO\nE\t\u0015!\u0003\u00038\"9\u0011\u0011O4\u0005\u0002\t\u0015\u0007\"\u0003B\u001fO\u0006\u0005I\u0011\u0001Bg\u0011%\u0011\u0019eZI\u0001\n\u0003\u0011)\u0005C\u0005\u0003T\u001e\f\n\u0011\"\u0001\u0003V\"I!1L4\u0002\u0002\u0013\u0005#Q\f\u0005\n\u0005S:\u0017\u0011!C\u0001\u0005WB\u0011Ba\u001dh\u0003\u0003%\tA!7\t\u0013\t}t-!A\u0005B\t\u0005\u0005\"\u0003BHO\u0006\u0005I\u0011\u0001Bo\u0011%\u0011YjZA\u0001\n\u0003\u0012\t\u000fC\u0005\u0003\"\u001e\f\t\u0011\"\u0011\u0003$\"I!QU4\u0002\u0002\u0013\u0005#q\u0015\u0005\n\u0005S;\u0017\u0011!C!\u0005K<\u0011ba2\u0016\u0003\u0003E\ta!3\u0007\u0013\t=V#!A\t\u0002\r-\u0007bBA9u\u0012\u000511\u001b\u0005\n\u0005KS\u0018\u0011!C#\u0005OC\u0011b!\u001e{\u0003\u0003%\ti!6\t\u0013\r}$0!A\u0005\u0002\u000em\u0007\"CBJu\u0006\u0005I\u0011BBK\u0005Y)\u00050Z2vi&|g\u000eT8h/\u0006$8\r[!di>\u0014(\u0002BA\u0003\u0003\u000f\tA\u0001\\8hg*!\u0011\u0011BA\u0006\u0003%\u00198\r[3ek2,'O\u0003\u0003\u0002\u000e\u0005=\u0011!\u0003=me\u0016dW-Y:f\u0015\u0011\t\t\"a\u0005\u0002\u0013a,'-[1mC\n\u001c(BAA\u000b\u0003\r\u0019w.\\\u0002\u0001'\u001d\u0001\u00111DA\u0014\u0003o\u0001B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0003\u0003C\tQa]2bY\u0006LA!!\n\u0002 \t1\u0011I\\=SK\u001a\u0004B!!\u000b\u000245\u0011\u00111\u0006\u0006\u0005\u0003[\ty#A\u0003bGR|'O\u0003\u0002\u00022\u0005!\u0011m[6b\u0013\u0011\t)$a\u000b\u0003\u000b\u0005\u001bGo\u001c:\u0011\t\u0005e\u00121I\u0007\u0003\u0003wQA!!\u0010\u0002@\u0005)1\u000f\u001c45U*!\u0011\u0011IA\u0018\u0003\u0015)g/\u001a8u\u0013\u0011\t)%a\u000f\u0003\u0019Mce\t\u000e&M_\u001e<\u0017N\\4\u0002/Q\f7o[#yK\u000e,H/[8o\u0019><7+\u001a:wS\u000e,\u0007\u0003BA&\u0003\u001bj!!a\u0001\n\t\u0005=\u00131\u0001\u0002\u0018)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8M_\u001e\u001cVM\u001d<jG\u0016\fab\u001d;pe\u0006<WmU3sm&\u001cW\r\u0005\u0003\u0002V\u0005}SBAA,\u0015\u0011\tI&a\u0017\u0002\u000fM,'O^5dK*!\u0011QLA\u0006\u0003\u001d\u0019Ho\u001c:bO\u0016LA!!\u0019\u0002X\tq1\u000b^8sC\u001e,7+\u001a:wS\u000e,\u0017!D:tKJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0003\u0002h\u00055TBAA5\u0015\u0011\tY'a\u0003\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0003\u0002p\u0005%$!D*T\u000bJ+\u0007o\\:ji>\u0014\u00180\u0001\u0004=S:LGO\u0010\u000b\t\u0003k\n9(!\u001f\u0002|A\u0019\u00111\n\u0001\t\u000f\u0005\u001dC\u00011\u0001\u0002J!9\u0011\u0011\u000b\u0003A\u0002\u0005M\u0003bBA2\t\u0001\u0007\u0011QM\u0001\fKb,7-\u001e;j_:LE-\u0006\u0002\u0002\u0002B!\u00111QAI\u001d\u0011\t))!$\u0011\t\u0005\u001d\u0015qD\u0007\u0003\u0003\u0013SA!a#\u0002\u0018\u00051AH]8pizJA!a$\u0002 \u00051\u0001K]3eK\u001aLA!a%\u0002\u0016\n11\u000b\u001e:j]\u001eTA!a$\u0002 \u0005yQ\r_3dkRLwN\\%e?\u0012*\u0017\u000f\u0006\u0003\u0002\u001c\u0006\u0005\u0006\u0003BA\u000f\u0003;KA!a(\u0002 \t!QK\\5u\u0011%\t\u0019KBA\u0001\u0002\u0004\t\t)A\u0002yIE\nA\"\u001a=fGV$\u0018n\u001c8JI\u0002\na\u0001^1tW&#\u0017A\u0003;bg.LEm\u0018\u0013fcR!\u00111TAW\u0011%\t\u0019+CA\u0001\u0002\u0004\t\t)A\u0004uCN\\\u0017\n\u001a\u0011\u0002%1\f7\u000f^#wK:$H+[7fgR\fW\u000e]\u000b\u0003\u0003k\u0003B!a.\u0002B6\u0011\u0011\u0011\u0018\u0006\u0005\u0003w\u000bi,\u0001\u0003uS6,'BAA`\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0017\u0011\u0018\u0002\b\u0013:\u001cH/\u00198u\u0003Ya\u0017m\u001d;Fm\u0016tG\u000fV5nKN$\u0018-\u001c9`I\u0015\fH\u0003BAN\u0003\u0013D\u0011\"a)\r\u0003\u0003\u0005\r!!.\u0002'1\f7\u000f^#wK:$H+[7fgR\fW\u000e\u001d\u0011\u0002\u000fI,7-Z5wKV\u0011\u0011\u0011\u001b\t\u0005\u0003'\f).D\u0001\u0001\u0013\u0011\t9.a\r\u0003\u000fI+7-Z5wK\u0006A\u0001o\\:u'R|\u0007\u000f\u0006\u0002\u0002\u001c\u0006y\u0001.\u00198eY\u0016<\u0016\r^2i\u001bN<7\u000f\u0006\u0003\u0002\u001c\u0006\u0005\bbBAr!\u0001\u0007\u0011Q]\u0001\u000bo\u0006$8\r[3s\u001bN<\u0007cAAt;9\u0019\u0011\u0011\u001e\u000b\u000f\t\u0005-\u00181 \b\u0005\u0003[\fIP\u0004\u0003\u0002p\u0006]h\u0002BAy\u0003ktA!a\"\u0002t&\u0011\u0011QC\u0005\u0005\u0003#\t\u0019\"\u0003\u0003\u0002\u000e\u0005=\u0011\u0002BA\u0005\u0003\u0017IA!!\u0002\u0002\b\u00051R\t_3dkRLwN\u001c'pO^\u000bGo\u00195BGR|'\u000fE\u0002\u0002LU\u00192!FA\u000e)\t\ty0A\u000fM\u001f\u001e{6\tS+O\u0017~+e\n\u0016*Z?\u000e\u0013V)\u0011+F\t~+e+\u0012(U\u0003yaujR0D\u0011Vs5jX#O)JKvl\u0011*F\u0003R+EiX#W\u000b:#\u0006%\u0001\bQ\u0013:;ulU*F?\u00163VI\u0014+\u0002\u001fAKejR0T'\u0016{VIV#O)\u0002\n!$\u0012-F\u0007V#\u0016j\u0014(`\u0019>;ul\u0015+B)V\u001bv,\u0012,F\u001dR\u000b1$\u0012-F\u0007V#\u0016j\u0014(`\u0019>;ul\u0015+B)V\u001bv,\u0012,F\u001dR\u0003#AC,bi\u000eDWM]'tON\u0019Q$a\u0007*\u000bu\tvmH\u001e\u0003\u000b\rCWmY6\u0014\u0013E\u000bYBa\u0007\u0003 \t\u0015\u0002c\u0001B\u000f;5\tQ\u0003\u0005\u0003\u0002\u001e\t\u0005\u0012\u0002\u0002B\u0012\u0003?\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0003(\tEb\u0002\u0002B\u0015\u0005[qA!a\"\u0003,%\u0011\u0011\u0011E\u0005\u0005\u0005_\ty\"A\u0004qC\u000e\\\u0017mZ3\n\t\tM\"Q\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0005\u0005_\ty\u0002\u0006\u0003\u0003:\tm\u0002c\u0001B\u000f#\"9\u0011Q\u0010+A\u0002\u0005\u0005\u0015\u0001B2paf$BA!\u000f\u0003B!I\u0011QP+\u0011\u0002\u0003\u0007\u0011\u0011Q\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u00119E\u000b\u0003\u0002\u0002\n%3F\u0001B&!\u0011\u0011iEa\u0016\u000e\u0005\t=#\u0002\u0002B)\u0005'\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\tU\u0013qD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B-\u0005\u001f\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!q\f\t\u0005\u0005C\u00129'\u0004\u0002\u0003d)!!QMA_\u0003\u0011a\u0017M\\4\n\t\u0005M%1M\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005[\u0002B!!\b\u0003p%!!\u0011OA\u0010\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u00119H! \u0011\t\u0005u!\u0011P\u0005\u0005\u0005w\nyBA\u0002B]fD\u0011\"a)Z\u0003\u0003\u0005\rA!\u001c\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa!\u0011\r\t\u0015%1\u0012B<\u001b\t\u00119I\u0003\u0003\u0003\n\u0006}\u0011AC2pY2,7\r^5p]&!!Q\u0012BD\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\tM%\u0011\u0014\t\u0005\u0003;\u0011)*\u0003\u0003\u0003\u0018\u0006}!a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003G[\u0016\u0011!a\u0001\u0005o\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!q\fBP\u0011%\t\u0019\u000bXA\u0001\u0002\u0004\u0011i'\u0001\u0005iCND7i\u001c3f)\t\u0011i'\u0001\u0005u_N#(/\u001b8h)\t\u0011y&\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005'\u0013i\u000bC\u0005\u0002$~\u000b\t\u00111\u0001\u0003x\tAa*Z<F]R\u0014\u0018pE\u0005h\u00037\u0011YBa\b\u0003&\u0005Ya.Z<F]R\u0014\u00180\u0016:j+\t\u00119\f\u0005\u0003\u0003:\n}VB\u0001B^\u0015\u0011\u0011i,!0\u0002\u00079,G/\u0003\u0003\u0003B\nm&aA+S\u0013\u0006aa.Z<F]R\u0014\u00180\u0016:jAQ1!q\u0019Be\u0005\u0017\u00042A!\bh\u0011\u001d\ti\b\u001ca\u0001\u0003\u0003CqAa-m\u0001\u0004\u00119\f\u0006\u0004\u0003H\n='\u0011\u001b\u0005\n\u0003{j\u0007\u0013!a\u0001\u0003\u0003C\u0011Ba-n!\u0003\u0005\rAa.\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u001b\u0016\u0005\u0005o\u0013I\u0005\u0006\u0003\u0003x\tm\u0007\"CARe\u0006\u0005\t\u0019\u0001B7)\u0011\u0011\u0019Ja8\t\u0013\u0005\rF/!AA\u0002\t]D\u0003\u0002B0\u0005GD\u0011\"a)v\u0003\u0003\u0005\rA!\u001c\u0015\t\tM%q\u001d\u0005\n\u0003GC\u0018\u0011!a\u0001\u0005o\u0012!b\u0015;beR<\u0016\r^2i'-y\u00121\u0004B\u000e\u0005[\u0014yB!\n\u0011\t\u0005%\"q^\u0005\u0005\u0005c\fYCA\u0011O_N+'/[1mSj\fG/[8o-\u0016\u0014\u0018NZ5dCRLwN\u001c(fK\u0012,G-\u0001\u0003tS:\\WC\u0001B|!\u0011\u0011Ipa\u0003\u000e\u0005\tm(\u0002\u0002B\u007f\u0005\u007f\f1a]:f\u0015\u0011\u0019\taa\u0001\u0002\u0005I\u001c(\u0002BB\u0003\u0007\u000f\t!a^:\u000b\u0005\r%\u0011!\u00026bm\u0006D\u0018\u0002BB\u0007\u0005w\u0014AbU:f\u000bZ,g\u000e^*j].\fQa]5oW\u0002\"\u0002ba\u0005\u0004\u0016\r]1\u0011\u0004\t\u0004\u0005;y\u0002bBATM\u0001\u0007\u0011\u0011\u0011\u0005\b\u0003{2\u0003\u0019AAA\u0011\u001d\u0011\u0019P\na\u0001\u0005o$\u0002ba\u0005\u0004\u001e\r}1\u0011\u0005\u0005\n\u0003O;\u0003\u0013!a\u0001\u0003\u0003C\u0011\"! (!\u0003\u0005\r!!!\t\u0013\tMx\u0005%AA\u0002\t]\u0018AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0007OQCAa>\u0003JQ!!qOB\u0016\u0011%\t\u0019+LA\u0001\u0002\u0004\u0011i\u0007\u0006\u0003\u0003\u0014\u000e=\u0002\"CAR_\u0005\u0005\t\u0019\u0001B<)\u0011\u0011yfa\r\t\u0013\u0005\r\u0006'!AA\u0002\t5D\u0003\u0002BJ\u0007oA\u0011\"a)4\u0003\u0003\u0005\rAa\u001e\u0003\u0019M#x\u000e],bi\u000eD\u0017N\\4\u0014\u0013m\nYBa\u0007\u0003 \t\u0015B\u0003BB \u0007\u0003\u00022A!\b<\u0011\u001d\tiH\u0010a\u0001\u0003\u0003#Baa\u0010\u0004F!I\u0011QP \u0011\u0002\u0003\u0007\u0011\u0011\u0011\u000b\u0005\u0005o\u001aI\u0005C\u0005\u0002$\u000e\u000b\t\u00111\u0001\u0003nQ!!1SB'\u0011%\t\u0019+RA\u0001\u0002\u0004\u00119\b\u0006\u0003\u0003`\rE\u0003\"CAR\r\u0006\u0005\t\u0019\u0001B7)\u0011\u0011\u0019j!\u0016\t\u0013\u0005\r\u0016*!AA\u0002\t]\u0014AC*uCJ$x+\u0019;dQB\u0019!QD\u001b\u0014\u000bU\u001aif!\u001b\u0011\u0019\r}3QMAA\u0003\u0003\u00139pa\u0005\u000e\u0005\r\u0005$\u0002BB2\u0003?\tqA];oi&lW-\u0003\u0003\u0004h\r\u0005$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogA!11NB9\u001b\t\u0019iG\u0003\u0003\u0004p\u0005u\u0016AA5p\u0013\u0011\u0011\u0019d!\u001c\u0015\u0005\re\u0013!B1qa2LH\u0003CB\n\u0007s\u001aYh! \t\u000f\u0005\u001d\u0006\b1\u0001\u0002\u0002\"9\u0011Q\u0010\u001dA\u0002\u0005\u0005\u0005b\u0002Bzq\u0001\u0007!q_\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019\u0019ia$\u0011\r\u0005u1QQBE\u0013\u0011\u00199)a\b\u0003\r=\u0003H/[8o!)\tiba#\u0002\u0002\u0006\u0005%q_\u0005\u0005\u0007\u001b\u000byB\u0001\u0004UkBdWm\r\u0005\n\u0007#K\u0014\u0011!a\u0001\u0007'\t1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u00199\n\u0005\u0003\u0003b\re\u0015\u0002BBN\u0005G\u0012aa\u00142kK\u000e$\u0018\u0001D*u_B<\u0016\r^2iS:<\u0007c\u0001B\u000f\u0017N)1ja)\u0004jAA1qLBS\u0003\u0003\u001by$\u0003\u0003\u0004(\u000e\u0005$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u00111q\u0014\u000b\u0005\u0007\u007f\u0019i\u000bC\u0004\u0002~9\u0003\r!!!\u0015\t\rE61\u0017\t\u0007\u0003;\u0019))!!\t\u0013\rEu*!AA\u0002\r}\u0012!B\"iK\u000e\\\u0007c\u0001B\u000fCN)\u0011ma/\u0004jAA1qLBS\u0003\u0003\u0013I\u0004\u0006\u0002\u00048R!!\u0011HBa\u0011\u001d\ti\b\u001aa\u0001\u0003\u0003#Ba!-\u0004F\"I1\u0011S3\u0002\u0002\u0003\u0007!\u0011H\u0001\t\u001d\u0016<XI\u001c;ssB\u0019!Q\u0004>\u0014\u000bi\u001cim!\u001b\u0011\u0015\r}3qZAA\u0005o\u00139-\u0003\u0003\u0004R\u000e\u0005$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u00111\u0011\u001a\u000b\u0007\u0005\u000f\u001c9n!7\t\u000f\u0005uT\u00101\u0001\u0002\u0002\"9!1W?A\u0002\t]F\u0003BBo\u0007K\u0004b!!\b\u0004\u0006\u000e}\u0007\u0003CA\u000f\u0007C\f\tIa.\n\t\r\r\u0018q\u0004\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\rEe0!AA\u0002\t\u001d\u0017aE:f]\u0012,e/\u001a8u)>\fE\u000e\\*j].\u001cHCBAN\u0007W\u001ci\u000fC\u0004\u0002~E\u0001\r!!!\t\u000f\u0005\u0005\u0013\u00031\u0001\u0004pB!!\u0011`By\u0013\u0011\u0019\u0019Pa?\u0003!=+HOY8v]\u0012\u001c6/Z#wK:$\u0018AE:ue\u0016\fWnQ;se\u0016tGo\u0015;bi\u0016$B!a'\u0004z\"9\u0011Q\u0010\nA\u0002\u0005\u0005\u0015aD:ue\u0016\fW\u000eT1ti\u000eCWO\\6\u0015\t\u0005m5q \u0005\b\u0003{\u001a\u0002\u0019AAAQ\r\u0001A1\u0001\t\u0005\t\u000b!\t\"\u0004\u0002\u0005\b)!A\u0011\u0002C\u0006\u0003\u0019\u0019\bO]5oO*!\u0011\u0011\u0007C\u0007\u0015\u0011!y!a\u0003\u0002\u000fM,\b\u000f]8si&!A1\u0003C\u0004\u0005-\u0019\u0006O]5oO\u0006\u001bGo\u001c:")
public class ExecutionLogWatchActor
implements Actor,
SLF4JLogging {
    private final TaskExecutionLogService taskExecutionLogService;
    private final StorageService storageService;
    private final SSERepository sseRepository;
    private String executionId;
    private String taskId;
    private Instant lastEventTimestamp;
    private transient Logger log;
    private ActorContext context;
    private ActorRef self;
    private volatile transient boolean bitmap$trans$0;

    public static String EXECUTION_LOG_STATUS_EVENT() {
        return ExecutionLogWatchActor$.MODULE$.EXECUTION_LOG_STATUS_EVENT();
    }

    public static String PING_SSE_EVENT() {
        return ExecutionLogWatchActor$.MODULE$.PING_SSE_EVENT();
    }

    public static String LOG_CHUNK_ENTRY_CREATED_EVENT() {
        return ExecutionLogWatchActor$.MODULE$.LOG_CHUNK_ENTRY_CREATED_EVENT();
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preStart() throws Exception {
        Actor.preStart$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    private Logger log$lzycompute() {
        ExecutionLogWatchActor executionLogWatchActor = this;
        synchronized (executionLogWatchActor) {
            if (!this.bitmap$trans$0) {
                this.log = SLF4JLogging.log$((SLF4JLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public String executionId() {
        return this.executionId;
    }

    public void executionId_$eq(String x$1) {
        this.executionId = x$1;
    }

    public String taskId() {
        return this.taskId;
    }

    public void taskId_$eq(String x$1) {
        this.taskId = x$1;
    }

    public Instant lastEventTimestamp() {
        return this.lastEventTimestamp;
    }

    public void lastEventTimestamp_$eq(Instant x$1) {
        this.lastEventTimestamp = x$1;
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return LoggingReceive$.MODULE$.apply((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutionLogWatchActor $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof WatcherMsg) {
                    WatcherMsg watcherMsg = (WatcherMsg)A1;
                    this.$outer.com$xebialabs$xlrelease$scheduler$logs$ExecutionLogWatchActor$$handleWatchMsgs(watcherMsg);
                    return (B1)BoxedUnit.UNIT;
                }
                if (ReceiveTimeout$.MODULE$.equals(A1)) {
                    this.$outer.self().$bang((Object)new Check(this.$outer.executionId()), this.$outer.self());
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (object instanceof WatcherMsg) {
                    return true;
                }
                return ReceiveTimeout$.MODULE$.equals(object);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.context());
    }

    public void postStop() {
        this.sseRepository.closeAll(this.executionId());
    }

    public void com$xebialabs$xlrelease$scheduler$logs$ExecutionLogWatchActor$$handleWatchMsgs(WatcherMsg watcherMsg) {
        WatcherMsg watcherMsg2 = watcherMsg;
        if (watcherMsg2 instanceof StartWatch) {
            StartWatch startWatch = (StartWatch)watcherMsg2;
            String taskId = startWatch.taskId();
            String executionId = startWatch.executionId();
            SseEventSink sseEventSink = startWatch.sink();
            this.executionId_$eq(executionId);
            this.taskId_$eq(taskId);
            this.sseRepository.addSink(executionId, sseEventSink);
            this.streamCurrentState(executionId);
            this.streamLastChunk(executionId);
            this.self().$bang((Object)new Check(executionId), this.self());
            return;
        }
        if (watcherMsg2 instanceof StopWatching) {
            StopWatching stopWatching = (StopWatching)watcherMsg2;
            String executionId = stopWatching.executionId();
            this.sseRepository.closeAll(executionId);
            this.self().$bang((Object)new Check(executionId), this.self());
            return;
        }
        if (watcherMsg2 instanceof Check) {
            Check check = (Check)watcherMsg2;
            String executionId = check.executionId();
            Set<SseEventSink> openSinks = this.sseRepository.get(executionId);
            if (openSinks.isEmpty()) {
                this.context().stop(this.self());
                return;
            }
            Option<TaskExecutionEntry> maybeExecutionEntry = this.taskExecutionLogService.getTaskExecutionEntry(this.taskId(), executionId);
            boolean executionIsCompletedOrMissing = maybeExecutionEntry.forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ExecutionLogWatchActor.$anonfun$handleWatchMsgs$1(x$3)));
            if (executionIsCompletedOrMissing) {
                this.self().$bang((Object)new StopWatching(executionId), this.self());
                return;
            }
            long durationSinceLastEvent = java.time.Duration.between(this.lastEventTimestamp(), Instant.now()).toSeconds();
            if (durationSinceLastEvent > 10L && durationSinceLastEvent < 60L) {
                OutboundSseEvent ping = this.sseRepository.newEventBuilder().name(ExecutionLogWatchActor$.MODULE$.PING_SSE_EVENT()).data((Object)new String(":\n\n")).build();
                this.sendEventToAllSinks(executionId, ping);
                return;
            }
            if (durationSinceLastEvent >= 60L) {
                this.self().$bang((Object)new StopWatching(executionId), this.self());
                return;
            }
            return;
        }
        if (watcherMsg2 instanceof NewEntry) {
            NewEntry newEntry = (NewEntry)watcherMsg2;
            String executionId = newEntry.executionId();
            URI newEntryUri = newEntry.newEntryUri();
            this.lastEventTimestamp_$eq(Instant.now());
            byte[] payload = (byte[])Using$.MODULE$.resource((Object)this.storageService.get((StorageEntryRef)new JobEntryRef(newEntryUri)), (Function1 & Serializable)content -> IOUtils.toByteArray((InputStream)content), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            OutboundSseEvent event = this.sseRepository.newEventBuilder().name(ExecutionLogWatchActor$.MODULE$.LOG_CHUNK_ENTRY_CREATED_EVENT()).data((Object)new String(payload)).build();
            this.sendEventToAllSinks(executionId, event);
            return;
        }
        throw new MatchError((Object)watcherMsg2);
    }

    private void sendEventToAllSinks(String executionId, OutboundSseEvent event) {
        this.sseRepository.sendEventToSink(executionId, event);
    }

    private void streamCurrentState(String executionId) {
        Tuple3 tuple3;
        Option<TaskExecutionEntry> option = this.taskExecutionLogService.getTaskExecutionEntry(this.taskId(), executionId);
        if (option instanceof Some) {
            Some some = (Some)option;
            TaskExecutionEntry row = (TaskExecutionEntry)some.value();
            tuple3 = new Tuple3((Object)(row.endDate() == null ? "in_progress" : "closed"), (Object)BoxesRunTime.boxToInteger((int)row.lastJob()), (Object)BoxesRunTime.boxToInteger((int)row.lastChunk()));
        } else if (None$.MODULE$.equals(option)) {
            tuple3 = new Tuple3((Object)"unknown", (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToInteger((int)-1));
        } else {
            throw new MatchError(option);
        }
        Tuple3 tuple32 = tuple3;
        if (tuple32 == null) {
            throw new MatchError((Object)tuple32);
        }
        String status = (String)tuple32._1();
        int jobId = BoxesRunTime.unboxToInt((Object)tuple32._2());
        int chunk = BoxesRunTime.unboxToInt((Object)tuple32._3());
        Tuple3 tuple33 = new Tuple3((Object)status, (Object)BoxesRunTime.boxToInteger((int)jobId), (Object)BoxesRunTime.boxToInteger((int)chunk));
        String status2 = (String)tuple33._1();
        int jobId2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
        int chunk2 = BoxesRunTime.unboxToInt((Object)tuple33._3());
        String payload = status2 + ", " + jobId2 + ", " + chunk2;
        OutboundSseEvent statusEvent = this.sseRepository.newEventBuilder().name(ExecutionLogWatchActor$.MODULE$.EXECUTION_LOG_STATUS_EVENT()).data((Object)new String(payload)).build();
        this.sseRepository.sendEventToSink(executionId, statusEvent);
    }

    private void streamLastChunk(String executionId) {
        Option<TaskExecutionEntry> maybeRow = this.taskExecutionLogService.getTaskExecutionEntry(this.taskId(), executionId);
        maybeRow.foreach((Function1 & Serializable)row -> {
            ExecutionLogWatchActor.$anonfun$streamLastChunk$1(this, row);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$handleWatchMsgs$1(TaskExecutionEntry x$3) {
        return x$3.endDate() != null;
    }

    public static final /* synthetic */ void $anonfun$streamLastChunk$1(ExecutionLogWatchActor $this, TaskExecutionEntry row) {
        String taskIdHash = row.taskIdHash();
        String executionId = row.executionId();
        int jobId = row.lastJob();
        int chunk = row.lastChunk();
        String uriPath = "/jobs/" + taskIdHash + "/" + executionId + "/" + jobId + "/" + chunk;
        String uriScheme = "xlr-local";
        URI entryUri = URI.create(uriScheme + "://" + uriPath);
        byte[] payload = (byte[])Using$.MODULE$.resource((Object)$this.storageService.get((StorageEntryRef)new JobEntryRef(entryUri)), (Function1 & Serializable)content -> IOUtils.toByteArray((InputStream)content), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        OutboundSseEvent event = $this.sseRepository.newEventBuilder().name(ExecutionLogWatchActor$.MODULE$.LOG_CHUNK_ENTRY_CREATED_EVENT()).data((Object)new String(payload)).build();
        $this.sseRepository.sendEventToSink(executionId, event);
    }

    public ExecutionLogWatchActor(TaskExecutionLogService taskExecutionLogService, StorageService storageService, SSERepository sseRepository) {
        this.taskExecutionLogService = taskExecutionLogService;
        this.storageService = storageService;
        this.sseRepository = sseRepository;
        Actor.$init$((Actor)this);
        SLF4JLogging.$init$((SLF4JLogging)this);
        this.lastEventTimestamp = Instant.now();
        this.context().setReceiveTimeout((Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds());
        Statics.releaseFence();
    }

    public static class Check
    implements WatcherMsg,
    Product,
    Serializable {
        private final String executionId;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public String executionId() {
            return this.executionId;
        }

        public Check copy(String executionId) {
            return new Check(executionId);
        }

        public String copy$default$1() {
            return this.executionId();
        }

        public String productPrefix() {
            return "Check";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.executionId();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Check;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "executionId";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Check)) return false;
            boolean bl = true;
            if (!bl) return false;
            Check check = (Check)x$1;
            String string = this.executionId();
            String string2 = check.executionId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!check.canEqual(this)) return false;
            return true;
        }

        public Check(String executionId) {
            this.executionId = executionId;
            Product.$init$((Product)this);
        }
    }

    public static class NewEntry
    implements WatcherMsg,
    Product,
    Serializable {
        private final String executionId;
        private final URI newEntryUri;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public String executionId() {
            return this.executionId;
        }

        public URI newEntryUri() {
            return this.newEntryUri;
        }

        public NewEntry copy(String executionId, URI newEntryUri) {
            return new NewEntry(executionId, newEntryUri);
        }

        public String copy$default$1() {
            return this.executionId();
        }

        public URI copy$default$2() {
            return this.newEntryUri();
        }

        public String productPrefix() {
            return "NewEntry";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.executionId();
                }
                case 1: {
                    return this.newEntryUri();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof NewEntry;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "executionId";
                }
                case 1: {
                    return "newEntryUri";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof NewEntry)) return false;
            boolean bl = true;
            if (!bl) return false;
            NewEntry newEntry = (NewEntry)x$1;
            String string = this.executionId();
            String string2 = newEntry.executionId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            URI uRI = this.newEntryUri();
            URI uRI2 = newEntry.newEntryUri();
            if (uRI == null) {
                if (uRI2 != null) {
                    return false;
                }
            } else if (!((Object)uRI).equals(uRI2)) return false;
            if (!newEntry.canEqual(this)) return false;
            return true;
        }

        public NewEntry(String executionId, URI newEntryUri) {
            this.executionId = executionId;
            this.newEntryUri = newEntryUri;
            Product.$init$((Product)this);
        }
    }

    public static class StartWatch
    implements WatcherMsg,
    NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final String taskId;
        private final String executionId;
        private final SseEventSink sink;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String taskId() {
            return this.taskId;
        }

        @Override
        public String executionId() {
            return this.executionId;
        }

        public SseEventSink sink() {
            return this.sink;
        }

        public StartWatch copy(String taskId, String executionId, SseEventSink sink) {
            return new StartWatch(taskId, executionId, sink);
        }

        public String copy$default$1() {
            return this.taskId();
        }

        public String copy$default$2() {
            return this.executionId();
        }

        public SseEventSink copy$default$3() {
            return this.sink();
        }

        public String productPrefix() {
            return "StartWatch";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.taskId();
                }
                case 1: {
                    return this.executionId();
                }
                case 2: {
                    return this.sink();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof StartWatch;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "taskId";
                }
                case 1: {
                    return "executionId";
                }
                case 2: {
                    return "sink";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof StartWatch)) return false;
            boolean bl = true;
            if (!bl) return false;
            StartWatch startWatch = (StartWatch)x$1;
            String string = this.taskId();
            String string2 = startWatch.taskId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.executionId();
            String string4 = startWatch.executionId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            SseEventSink sseEventSink = this.sink();
            SseEventSink sseEventSink2 = startWatch.sink();
            if (sseEventSink == null) {
                if (sseEventSink2 != null) {
                    return false;
                }
            } else if (!sseEventSink.equals(sseEventSink2)) return false;
            if (!startWatch.canEqual(this)) return false;
            return true;
        }

        public StartWatch(String taskId, String executionId, SseEventSink sink) {
            this.taskId = taskId;
            this.executionId = executionId;
            this.sink = sink;
            Product.$init$((Product)this);
        }
    }

    public static class StopWatching
    implements WatcherMsg,
    Product,
    Serializable {
        private final String executionId;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public String executionId() {
            return this.executionId;
        }

        public StopWatching copy(String executionId) {
            return new StopWatching(executionId);
        }

        public String copy$default$1() {
            return this.executionId();
        }

        public String productPrefix() {
            return "StopWatching";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.executionId();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof StopWatching;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "executionId";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof StopWatching)) return false;
            boolean bl = true;
            if (!bl) return false;
            StopWatching stopWatching = (StopWatching)x$1;
            String string = this.executionId();
            String string2 = stopWatching.executionId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!stopWatching.canEqual(this)) return false;
            return true;
        }

        public StopWatching(String executionId) {
            this.executionId = executionId;
            Product.$init$((Product)this);
        }
    }

    public static interface WatcherMsg {
        public String executionId();
    }
}

