package com.xebialabs.xlrelease.upgrade.settings

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.features.settings.JobSchedulerFeatureSettings
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.scheduler.strategies.DefaultJobSchedulerStrategySettings
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.BaseInitializingUpgrade
import grizzled.slf4j.Logging

class JobSchedulerFeatureSettingsInitializer(configurationRepository: ConfigurationRepository)
  extends BaseInitializingUpgrade
    with Logging {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "23.1.0#5")

  override def doUpgrade(): Boolean = {
    val featureType = Type.valueOf(classOf[JobSchedulerFeatureSettings])
    val featureSetting = configurationRepository.findFirstByType[JobSchedulerFeatureSettings](featureType)
    if (featureSetting.isEmpty) {
      val feature: JobSchedulerFeatureSettings = featureType.getDescriptor().newInstance("")
      feature.generateId()
      feature.setStrategy(new DefaultJobSchedulerStrategySettings())
      configurationRepository.create(feature)
    }
    true
  }
}
