package com.xebialabs.xlrelease.support.report

import com.xebialabs.xlplatform.support.report.ReportDataProvider
import com.xebialabs.xlrelease.actors.ReleaseExecutionActor.METRIC_PREFIX
import com.xebialabs.xlrelease.metrics.XlrMetricRegistry
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class MessageStatisticsProvider extends ReportDataProvider with Logging {
  override val name: String = "messages"

  override def collectStatistics: Map[String, Any] = {
    val truncatePrefix = METRIC_PREFIX.length
    Map[String, Any]("messages" -> XlrMetricRegistry.metricRegistry.getMeters().asScala
      .filter {
        case (name, _) => name.startsWith(METRIC_PREFIX)
      }
      .map {
        case (k, v) => Map[String, Any]("message" -> k.substring(truncatePrefix), "rate" -> v.getFifteenMinuteRate.formatted("%.3f")).asJava
      }
      .toList.asJava
    )
  }

}


