package com.xebialabs.xlrelease.scheduler.logs

import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionRepository.{DeleteOperation, FindOperation, UpdateTaskExecutionOperation}
import com.xebialabs.xlrelease.storage.domain.LogEntry
import org.springframework.data.domain.{Page, Pageable}

import java.time.Instant

trait TaskExecutionRepository {
  def read(taskId: String, executionId: String): Option[TaskExecutionEntry]

  def update(updateOperation: UpdateTaskExecutionOperation): Option[TaskExecutionEntry]

  def delete(deleteOperation: DeleteOperation): Unit

  def find(findOperation: FindOperation, pageable: Pageable): Page[TaskExecutionEntry]
}

object TaskExecutionRepository {
  sealed trait FindOperationComparator

  case object GreaterThan extends FindOperationComparator
  case object LessThan extends FindOperationComparator

  sealed trait FindOperation

  case class ByTaskId(taskId: String) extends FindOperation
  case class FinishedTaskAndExecutions(comparator: FindOperationComparator, lastModifiedDate: Instant) extends FindOperation

  sealed trait UpdateTaskExecutionOperation

  case class FinishExecution(taskId: String, executionId: String, endDate: Instant) extends UpdateTaskExecutionOperation
  case class UpdateWithLogEntry(logEntry: LogEntry, endDate: Option[Instant]) extends UpdateTaskExecutionOperation

  sealed trait DeleteOperation

  case class Delete(taskId: String, executionId: String) extends DeleteOperation
  case class DeleteWithTaskExecutionEntry(entry: TaskExecutionEntry) extends DeleteOperation
}
