package com.xebialabs.xlrelease.features

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.features.distributed.BaseDistributedFeature
import com.xebialabs.xlrelease.features.settings.{JobSchedulerStrategySettings, JobSchedulerFeatureSettings}
import com.xebialabs.xlrelease.scheduler.strategies.DefaultJobSchedulerStrategySettings


trait JobSchedulerFeature {
  def strategy: JobSchedulerStrategySettings

}

object JobSchedulerFeature extends BaseDistributedFeature[JobSchedulerFeatureSettings] with JobSchedulerFeature {
  val defaultStrategy: JobSchedulerStrategySettings = Type.valueOf(classOf[DefaultJobSchedulerStrategySettings]).getDescriptor.newInstance("")

  override def strategy: JobSchedulerStrategySettings = {
    val strategy = Option(featureSettings.strategy).getOrElse(defaultStrategy)
    strategy
  }
}