package com.xebialabs.xlrelease.export;

import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import com.xebialabs.xlplatform.upgrade.UpgraderHelper;
import com.xebialabs.xlrelease.upgrade.ImportUpgrade;

@Component
public class TemplateImportUpgradesProvider {
    private ApplicationContext applicationContext;

    private Set<ImportUpgrade> upgrades;

    @Autowired
    public TemplateImportUpgradesProvider(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void init() {
        this.upgrades = UpgraderHelper.findAndInstantiateSubTypesOf(ImportUpgrade.class, applicationContext);
        logger.debug("Found the following JSON upgraders: [{}]", upgrades);
    }

    public Set<ImportUpgrade> getUpgrades() {
        return upgrades;
    }

    private static final Logger logger = LoggerFactory.getLogger(TemplateImportUpgrader.class);
}
