package com.xebialabs.xlrelease.actors.cluster

import akka.actor.ActorSystem
import com.xebialabs.xlplatform.cluster.ClusterMode._
import com.xebialabs.xlplatform.cluster.XlCluster
import com.xebialabs.xlrelease.actors.ActorSystemHolder
import com.xebialabs.xlrelease.actors.initializer.ActorSystemInitializer
import com.xebialabs.xlrelease.config.XlrConfig
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class XlrActorSystem @Autowired()(xlrConfig: XlrConfig,
                                  actorSystemHolder: ActorSystemHolder,
                                  actorsInitializer: ActorSystemInitializer) {

  def boot() = {
    xlrConfig.cluster.mode match {
      case HotStandby =>
        val mgmtActorSystem = ActorSystem(xlrConfig.cluster.name, xlrConfig.akka.clusteredConfig)
        XlCluster.init(xlrConfig.cluster)
        XlCluster(mgmtActorSystem).start(() => initialize())
      case Full =>
        if (xlrConfig.isClusterWithSeedNodes) {
          initialize()
        } else {
          val mgmtActorSystem = actorSystemHolder.actorSystem
          XlCluster.init(xlrConfig.cluster)
          XlCluster(mgmtActorSystem).start(() => initialize())
        }
      case _ => initialize()
    }
  }

  private def initialize(): Unit = actorsInitializer.initialize()

  def stop(): Unit = {
    actorSystemHolder.shutdown()
  }
}
