package com.xebialabs.xlrelease.dispatcher

import java.security.{AccessControlContext, AccessController, PrivilegedAction}

object XlrPreserveAccessControlContext {
  // with all the laziness of Akka you never know when thread factory will be created, it might
  // be created when somebody is doing tell or askAndWait on an actor. So moving this code, that
  // captures AccessControlContext and ClassLoader to static initialization
  if (System.getSecurityManager != null) {
    System.getSecurityManager.checkPermission(new RuntimePermission("getClassLoader"))
    System.getSecurityManager.checkPermission(new RuntimePermission("setContextClassLoader"))
  }
  private val accessControlContext: AccessControlContext = AccessController.getContext
  private val contextClassLoader: ClassLoader = Thread.currentThread.getContextClassLoader

  def doPrivileged[T](fn: () => T): T = {
    AccessController.doPrivileged(new PrivilegedAction[T] {
      override def run(): T = {
        val classLoader = Thread.currentThread.getContextClassLoader
        Thread.currentThread().setContextClassLoader(contextClassLoader)
        try {
          fn.apply()
        } finally {
          Thread.currentThread().setContextClassLoader(classLoader)
        }
      }
    }, accessControlContext)
  }
}
