/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.security.PermissionLister;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;

@Path(value="/security")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class SecurityResource {
    private PermissionLister permissionLister;
    private RoleService roleService;

    @Autowired
    public SecurityResource(PermissionLister permissionLister, RoleService roleService) {
        this.permissionLister = permissionLister;
        this.roleService = roleService;
    }

    @GET
    public Map<String, Collection<String>> getGlobalPermissions() {
        return this.getMyGlobalPermissions();
    }

    private Map<String, Collection<String>> getMyGlobalPermissions() {
        Authentication authentication = Permissions.getAuthentication();
        List roles = this.roleService.getRolesFor(authentication);
        HashMap<String, Collection<String>> globalPermissionsAndRoles = this.convertToStringCollectionHashMap(this.permissionLister.listGlobalPermissions(roles));
        globalPermissionsAndRoles.put("roles", roles.stream().map(Role::getName).collect(Collectors.toList()));
        return globalPermissionsAndRoles;
    }

    private HashMap<String, Collection<String>> convertToStringCollectionHashMap(Map<String, List<String>> stringStringMultimap) {
        return new HashMap<String, Collection<String>>(stringStringMultimap.entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }
}

