package com.xebialabs.xlrelease.scheduler.workers

import com.xebialabs.xlrelease.actors.ReleaseActorService
import com.xebialabs.xlrelease.scheduler.workers.Worker.ExecuteJob
import com.xebialabs.xlrelease.scheduler.{FailJob, TaskJob}
import com.xebialabs.xlrelease.user.User
import org.springframework.stereotype.Component

@Component
class FailJobWorker(releaseActorService: ReleaseActorService) extends Worker {
  override def execute: ExecuteJob = {
    case FailJob(job, t) => job match {
      case taskJob: TaskJob[_] =>
        val comment: String = t match {
          case Some(errorMessage: String) => errorMessage
          case _ => ""
        }
        releaseActorService.failTaskWithRetry(taskJob.taskId, comment, User.SYSTEM, None, taskJob.taskRef.getExecutionId)
      case _ => ()
    }
  }

}
