package com.xebialabs.xlrelease.db

import liquibase.Liquibase
import liquibase.database.DatabaseFactory
import liquibase.database.jvm.JdbcConnection
import liquibase.resource.ClassLoaderResourceAccessor

import java.sql.Connection
import javax.sql.DataSource

trait LiquibaseSupport {

  def dataSource: DataSource

  def doWithLiquibase[T](changelogFile: String)(callback: (Liquibase) => T): T = {
    val connection: Connection = dataSource.getConnection
    try {
      val database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(new JdbcConnection(connection))
      val liquibase = new Liquibase(changelogFile, new ClassLoaderResourceAccessor(), database)
      callback(liquibase)
    } finally {
      connection.close()
    }
  }

}
