package com.xebialabs.xlrelease.actors.extension

import akka.actor.Actor.Receive
import akka.actor.{Actor, ActorRef}
import com.xebialabs.xlrelease.domain.Release

import scala.util.{Failure, Success, Try}


trait ActorExtensionHandlerFactory {

  def supports(clazz: Class[_ <: Actor]): Boolean

  def getHandler(self: ActorRef, sender: () => ActorRef, release: => Release): Receive

  protected def replyOrFail[T](sender: () => ActorRef)(call: => T): Unit = sender() ! (Try(call) match {
    case Success(t) if t != null => t
    case Success(t) => akka.actor.Status.Failure(new NullPointerException("Method returned null and this cannot be processed"))
    case Failure(ex) => akka.actor.Status.Failure(ex)
  })

}
