package com.xebialabs.xlrelease.variable

import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.deployit.plugin.api.udm.{Delegate, Parameters}
import com.xebialabs.xlrelease.domain.variables._
import com.xebialabs.xlrelease.support.akka.spring.ScalaSpringSupport
import org.springframework.context.{ApplicationContext, ApplicationContextAware}

import java.util
import java.util.{List => JList, Map => JMap}
import scala.beans.BeanProperty
import scala.jdk.CollectionConverters._


object DefaultCiValueProvider extends ValueProvider[PossibleValue, CiProvider] with ScalaSpringSupport with ApplicationContextAware {

  @BeanProperty
  var applicationContext: ApplicationContext = _

  private lazy val referenceCiVariableProviders: Seq[ReferenceCiVariableProvider[BaseConfigurationItem]] = springBeans[ReferenceCiVariableProvider[BaseConfigurationItem]].values().asScala.toSeq

  def getAllSupportedTypes: JList[ReferencedType] = {
    referenceCiVariableProviders.flatMap(_.getSupportedTypes()).sortBy(_.getLabel).asJava
  }

  @Delegate(name = ReferenceVariable.VARIABLE_DELEGATE)
  def getRawValueFromVariable(variable: Variable, methodName: String, attrs: JMap[String, String], parameters: Parameters): JList[AnyRef] = {
    variable match {
      case referenceVariable: ReferenceVariable =>
        getRawValue(referenceVariable)
      case _ =>
        List.empty.asJava
    }
  }

  override def getValueProviderConfigurationClass: Class[CiProvider] = classOf[CiProvider]

  override def possibleValues(valueProviderConfiguration: CiProvider): util.Collection[PossibleValue] = {
    valueProviderConfiguration.getVariable match {
      case variable: ReferenceVariable =>
        val referenceCiVariableProvider = findSupportedValueProvider(variable)
        if (referenceCiVariableProvider.isDefined) {
          referenceCiVariableProvider.get.possibleValues(valueProviderConfiguration).asJava
        } else {
          List.empty.asJava
        }
      case _ =>
        List.empty.asJava
    }
  }

  private def getRawValue(referenceVariable: ReferenceVariable): JList[AnyRef] = {
    val ciVariableProvider = findSupportedValueProvider(referenceVariable)
    if (ciVariableProvider.isDefined) {
      val rawValue: Option[AnyRef] = ciVariableProvider.get.getRawValue(referenceVariable)
      if (rawValue.isDefined) {
        Seq(rawValue.get).asJava
      } else {
        List.empty.asJava
      }
    } else {
      List.empty.asJava
    }
  }

  private def findSupportedValueProvider(referenceVariable: ReferenceVariable): Option[ReferenceCiVariableProvider[BaseConfigurationItem]] = {
    val referencedType = referenceVariable.getReferencedType
    referenceCiVariableProviders.find(vp => vp.getSupportedTypes().exists(t => t.getType.equals(referencedType)))
  }

}
