package com.xebialabs.xlrelease.actors

import akka.actor.ExtendedActorSystem
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlplatform.utils.ClassLoaderUtils.classLoader
import com.xebialabs.xlrelease.actors.kryoserializers._
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException
import com.xebialabs.xlrelease.repository.proxy.{ResolvableConfigurationItemReference, ResolvableLazyConfigurationItem}
import com.xebialabs.xlrelease.script.TaskSoftReference
import io.altoo.akka.serialization.kryo.DefaultKryoInitializer
import io.altoo.akka.serialization.kryo.serializer.scala._

class KryoInit extends DefaultKryoInitializer {

  override def postInit(kryo: ScalaKryo, system: ExtendedActorSystem): Unit = {
    // kryo.setWarnUnregisteredClasses(false)
    kryo.register(classOf[LogFriendlyNotFoundException], LogFriendlyNotFoundExceptionSerializer)
    kryo.addDefaultSerializer(classOf[ResolvableLazyConfigurationItem], ResolvableLazyConfigurationItemSerializer)
    kryo.addDefaultSerializer(classOf[TaskSoftReference[_]], TaskSoftReferenceSerializer)
    kryo.register(classOf[ResolvableConfigurationItemReference])
    kryo.register(classOf[Type])

    JavaKaffeeSerializers(kryo)
    TwitterChillSerializers(kryo)

    val tccl = classLoader
    kryo.setClassLoader(tccl)
  }
}
