/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.xebialabs.deployit.ServerConfiguration;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.springframework.http.HttpStatus;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.WebUtils;

public class UrlRedirectRewriteFilter
extends OncePerRequestFilter {
    private final boolean isFilterNotApplicable;
    private final String webContextRoot;

    public UrlRedirectRewriteFilter() {
        ServerConfiguration serverConfiguration = ServerConfiguration.getInstance();
        this.isFilterNotApplicable = serverConfiguration.getServerUrl().equals(UrlRedirectRewriteFilter.normalisePathWithSlash(serverConfiguration.getDerivedServerUrl()));
        this.webContextRoot = serverConfiguration.getWebContextRoot();
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)RedirectResponseWrapper.wrapIfNecessary(response, this.webContextRoot));
    }

    private static String normalisePathWithSlash(String path) {
        return path.endsWith("/") ? path : path + "/";
    }

    protected boolean shouldNotFilter(HttpServletRequest request) {
        return this.isFilterNotApplicable;
    }

    private static final class RedirectResponseWrapper
    extends HttpServletResponseWrapper {
        private String webContextRoot;

        private RedirectResponseWrapper(HttpServletResponse response, String webContextRoot) {
            super(response);
            this.webContextRoot = UrlRedirectRewriteFilter.normalisePathWithSlash(webContextRoot);
        }

        public void sendRedirect(String location) {
            this.setStatus(HttpStatus.SEE_OTHER.value());
            if (UrlUtils.isValidRedirectUrl((String)location)) {
                this.setHeader("Location", location);
            } else {
                this.setHeader("Location", this.webContextRoot + location);
            }
        }

        static HttpServletResponse wrapIfNecessary(HttpServletResponse response, String webContextRoot) {
            RedirectResponseWrapper wrapper = (RedirectResponseWrapper)((Object)WebUtils.getNativeResponse((ServletResponse)response, RedirectResponseWrapper.class));
            return wrapper != null ? response : new RedirectResponseWrapper(response, webContextRoot);
        }
    }
}

