/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.typesafe.config.Config;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlplatform.cluster.ClusterConfig;
import com.xebialabs.xlplatform.cluster.XlCluster$;
import com.xebialabs.xlplatform.cluster.XlClusterProvider;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.config.XlrConfig$;
import com.xebialabs.xlrelease.events.AsyncSubscribe;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.service.ArchiveCredentialsValidator;
import com.xebialabs.xlrelease.service.BroadcastService;
import com.xebialabs.xlrelease.service.DbConnectingCredentialsValidator;
import com.xebialabs.xlrelease.service.DbCredentialsChangeRequested;
import com.xebialabs.xlrelease.service.DbCredentialsChangeResult;
import com.xebialabs.xlrelease.service.DbCredentialsService$;
import com.xebialabs.xlrelease.service.RepositoryCredentialsValidator;
import com.xebialabs.xlrelease.service.XlrDatabase$;
import com.xebialabs.xlrelease.utils.ConfigEntry;
import com.xebialabs.xlrelease.utils.ConfigUtils$;
import com.xebialabs.xlrelease.utils.ResourceUtils$;
import com.zaxxer.hikari.HikariDataSource;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import org.slf4j.Marker;
import org.springframework.stereotype.Component;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u0005\rw!\u0002\u000e\u001c\u0011\u0003!c!\u0002\u0014\u001c\u0011\u00039\u0003\"\u0002\u0018\u0002\t\u0003y\u0003b\u0002\u0019\u0002\u0005\u0004%\t!\r\u0005\u0007u\u0005\u0001\u000b\u0011\u0002\u001a\t\u000fm\n!\u0019!C\u0001c!1A(\u0001Q\u0001\nIBq!P\u0001C\u0002\u0013\u0005\u0011\u0007\u0003\u0004?\u0003\u0001\u0006IA\r\u0005\b\u007f\u0005\u0011\r\u0011\"\u00012\u0011\u0019\u0001\u0015\u0001)A\u0005e!)\u0011)\u0001C\u0001\u0005\")q*\u0001C\u0001!\")A+\u0001C\u0001+\u001a!ae\u0007\u0001X\u0011!\u0001gB!A!\u0002\u0013\t\u0007\u0002C5\u000f\u0005\u0003\u0005\u000b\u0011B1\t\u0011)t!\u0011!Q\u0001\n-DQA\f\b\u0005\u00029DQa\u001d\b\u0005\u0002QDq!!\u0003\u000f\t\u0003\tY\u0001C\u0004\u0002*9!\t!a\u000b\t\u000f\u0005ub\u0002\"\u0003\u0002@!9\u0011\u0011\u000b\b\u0005\n\u0005M\u0003bBA3\u001d\u0011%\u0011q\r\u0005\b\u0003{rA\u0011BA@\u0003Q!%m\u0011:fI\u0016tG/[1mgN+'O^5dK*\u0011A$H\u0001\bg\u0016\u0014h/[2f\u0015\tqr$A\u0005yYJ,G.Z1tK*\u0011\u0001%I\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AI\u0001\u0004G>l7\u0001\u0001\t\u0003K\u0005i\u0011a\u0007\u0002\u0015\t\n\u001c%/\u001a3f]RL\u0017\r\\:TKJ4\u0018nY3\u0014\u0005\u0005A\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002I\u00051B-\u0019;bE\u0006\u001cX-V:fe\u000e{gNZ5h!\u0006$\b.F\u00013!\t\u0019\u0004(D\u00015\u0015\t)d'\u0001\u0003mC:<'\"A\u001c\u0002\t)\fg/Y\u0005\u0003sQ\u0012aa\u0015;sS:<\u0017a\u00063bi\u0006\u0014\u0017m]3Vg\u0016\u00148i\u001c8gS\u001e\u0004\u0016\r\u001e5!\u0003i!\u0017\r^1cCN,\u0007+Y:to>\u0014HmQ8oM&<\u0007+\u0019;i\u0003m!\u0017\r^1cCN,\u0007+Y:to>\u0014HmQ8oM&<\u0007+\u0019;iA\u00059\"/\u001a9peRLgnZ+tKJ\u001cuN\u001c4jOB\u000bG\u000f[\u0001\u0019e\u0016\u0004xN\u001d;j]\u001e,6/\u001a:D_:4\u0017n\u001a)bi\"\u0004\u0013a\u0007:fa>\u0014H/\u001b8h!\u0006\u001c8o^8sI\u000e{gNZ5h!\u0006$\b.\u0001\u000fsKB|'\u000f^5oOB\u000b7o]<pe\u0012\u001cuN\u001c4jOB\u000bG\u000f\u001b\u0011\u0002\u001dM,8mY3tg6+7o]1hKR\u00111)\u0014\t\u0003\t.s!!R%\u0011\u0005\u0019SS\"A$\u000b\u0005!\u001b\u0013A\u0002\u001fs_>$h(\u0003\u0002KU\u00051\u0001K]3eK\u001aL!!\u000f'\u000b\u0005)S\u0003\"\u0002(\f\u0001\u0004\u0019\u0015A\u00023c\u001d\u0006lW-A\rj]Z\fG.\u001b3De\u0016$WM\u001c;jC2\u001cX*Z:tC\u001e,GcA\"R%\")a\n\u0004a\u0001\u0007\")1\u000b\u0004a\u0001\u0007\u00069Q.Z:tC\u001e,\u0017\u0001F5om\u0006d\u0017\u000e\u001a#c\u001d\u0006lW-T3tg\u0006<W\r\u0006\u0002D-\")a*\u0004a\u0001\u0007N\u0019a\u0002\u000b-\u0011\u0005esV\"\u0001.\u000b\u0005mc\u0016!B:mMRR'\"A/\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\u0018.\u0003\u000f1{wmZ5oO\u00069\u0002\u0010\u001c:SKB|7/\u001b;pef$\u0015\r^1T_V\u00148-\u001a\t\u0003E\u001el\u0011a\u0019\u0006\u0003I\u0016\fa\u0001[5lCJL'B\u00014\"\u0003\u0019Q\u0018\r\u001f=fe&\u0011\u0001n\u0019\u0002\u0011\u0011&\\\u0017M]5ECR\f7k\\;sG\u0016\f1C]3q_J$\u0018N\\4ECR\f7k\\;sG\u0016\f\u0001C\u0019:pC\u0012\u001c\u0017m\u001d;TKJ4\u0018nY3\u0011\u0005\u0015b\u0017BA7\u001c\u0005A\u0011%o\\1eG\u0006\u001cHoU3sm&\u001cW\r\u0006\u0003paF\u0014\bCA\u0013\u000f\u0011\u0015\u0001'\u00031\u0001b\u0011\u0015I'\u00031\u0001b\u0011\u0015Q'\u00031\u0001l\u0003yyg\u000e\u00122De\u0016$WM\u001c;jC2\u001c8\t[1oO\u0016\u0014V-];fgR,G\r\u0006\u0002vqB\u0011\u0011F^\u0005\u0003o*\u0012A!\u00168ji\")\u0011p\u0005a\u0001u\u0006)QM^3oiB\u0011Qe_\u0005\u0003yn\u0011A\u0004\u00122De\u0016$WM\u001c;jC2\u001c8\t[1oO\u0016\u0014V-];fgR,G\r\u000b\u0002\u0014}B\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002;\u00051QM^3oiNLA!a\u0002\u0002\u0002\tq\u0011i]=oGN+(m]2sS\n,\u0017aE;qI\u0006$X\r\u00122De\u0016$WM\u001c;jC2\u001cHcB;\u0002\u000e\u0005E\u0011Q\u0003\u0005\u0007\u0003\u001f!\u0002\u0019A\"\u0002\u0011U\u001cXM\u001d8b[\u0016Da!a\u0005\u0015\u0001\u0004\u0019\u0015\u0001\u00039bgN<xN\u001d3\t\u000f\u0005]A\u00031\u0001\u0002\u001a\u0005AA-\u0019;bE\u0006\u001cX\r\u0005\u0003\u0002\u001c\u0005\u0005bbA\u0013\u0002\u001e%\u0019\u0011qD\u000e\u0002\u0017ac'\u000fR1uC\n\f7/Z\u0005\u0005\u0003G\t)CA\u0003WC2,X-C\u0002\u0002()\u00121\"\u00128v[\u0016\u0014\u0018\r^5p]\u0006Qc/\u00197jI\u0006$X-\u00118e!V\u0014G.[:i\u0007J,G-\u001a8uS\u0006d7o\u00115b]\u001e,'+Z9vKN$H\u0003CA\u0017\u0003g\t9$a\u000f\u0011\u0007\u0015\ny#C\u0002\u00022m\u0011\u0011\u0004\u00122De\u0016$WM\u001c;jC2\u001c8\t[1oO\u0016\u0014Vm];mi\"1\u0011QG\u000bA\u0002\r\u000b!\u0002\u001a2Vg\u0016\u0014h.Y7f\u0011\u0019\tI$\u0006a\u0001\u0007\u0006QAM\u0019)bgN<xN\u001d3\t\u000b9+\u0002\u0019A\"\u0002!U\u0004H-\u0019;f\t\u0006$\u0018mU8ve\u000e,G#B;\u0002B\u0005\r\u0003bBA\f-\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003\u000b2\u0002\u0019AA$\u0003\u0019\u0019wN\u001c4jOB!\u0011\u0011JA'\u001b\t\tYEC\u0002\u0002FuIA!a\u0014\u0002L\tI\u0001\f\u001c:D_:4\u0017nZ\u0001\nm\u0006d\u0017\u000eZ1u_J$B!!\u0016\u0002bA)\u0011&a\u0016\u0002\\%\u0019\u0011\u0011\f\u0016\u0003\r=\u0003H/[8o!\r)\u0013QL\u0005\u0004\u0003?Z\"\u0001\t#c\u0007>tg.Z2uS:<7I]3eK:$\u0018.\u00197t-\u0006d\u0017\u000eZ1u_JDa!a\u0019\u0018\u0001\u0004\u0019\u0015\u0001\u00043c\u001d\u0006lWm\u0015;sS:<\u0017aE:fi:+wo\u0011:fI\u0016tG/[1mg>sG\u0003CA5\u0003k\nI(a\u001f\u0011\u000b\u0005-\u0014\u0011O;\u000e\u0005\u00055$bAA8U\u0005!Q\u000f^5m\u0013\u0011\t\u0019(!\u001c\u0003\u0007Q\u0013\u0018\u0010\u0003\u0004\u0002xa\u0001\r!Y\u0001\u000bI\u0006$\u0018mU8ve\u000e,\u0007BBA\u001b1\u0001\u00071\t\u0003\u0004\u0002:a\u0001\raQ\u0001\u0014GJ,\u0017\r^3D_:4\u0017nZ#oiJLWm\u001d\u000b\t\u0003\u0003\u000by*!)\u0002$B1\u00111QAG\u0003'sA!!\"\u0002\n:\u0019a)a\"\n\u0003-J1!a#+\u0003\u001d\u0001\u0018mY6bO\u0016LA!a$\u0002\u0012\n\u00191+Z9\u000b\u0007\u0005-%\u0006\u0005\u0003\u0002\u0016\u0006mUBAAL\u0015\r\tI*H\u0001\u0006kRLGn]\u0005\u0005\u0003;\u000b9JA\u0006D_:4\u0017nZ#oiJL\bBBA\b3\u0001\u00071\t\u0003\u0004\u0002\u0014e\u0001\ra\u0011\u0005\b\u0003/I\u0002\u0019AA\rQ\rq\u0011q\u0015\t\u0005\u0003S\u000b9,\u0004\u0002\u0002,*!\u0011QVAX\u0003)\u0019H/\u001a:f_RL\b/\u001a\u0006\u0005\u0003c\u000b\u0019,A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\t),A\u0002pe\u001eLA!!/\u0002,\nI1i\\7q_:,g\u000e\u001e\u0015\u0004\u001d\u0005u\u0006cA@\u0002@&!\u0011\u0011YA\u0001\u00055)e/\u001a8u\u0019&\u001cH/\u001a8fe\u0002")
public class DbCredentialsService
implements Logging {
    private final HikariDataSource xlrRepositoryDataSource;
    private final HikariDataSource reportingDataSource;
    private final BroadcastService broadcastService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String invalidDbNameMessage(String dbName) {
        return DbCredentialsService$.MODULE$.invalidDbNameMessage(dbName);
    }

    public static String invalidCredentialsMessage(String dbName, String message) {
        return DbCredentialsService$.MODULE$.invalidCredentialsMessage(dbName, message);
    }

    public static String successMessage(String dbName) {
        return DbCredentialsService$.MODULE$.successMessage(dbName);
    }

    public static String reportingPasswordConfigPath() {
        return DbCredentialsService$.MODULE$.reportingPasswordConfigPath();
    }

    public static String reportingUserConfigPath() {
        return DbCredentialsService$.MODULE$.reportingUserConfigPath();
    }

    public static String databasePasswordConfigPath() {
        return DbCredentialsService$.MODULE$.databasePasswordConfigPath();
    }

    public static String databaseUserConfigPath() {
        return DbCredentialsService$.MODULE$.databaseUserConfigPath();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DbCredentialsService dbCredentialsService = this;
        synchronized (dbCredentialsService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @AsyncSubscribe
    public void onDbCredentialsChangeRequested(DbCredentialsChangeRequested event) {
        this.updateDbCredentials(event.dbUsername(), event.dbPassword(), event.database());
    }

    public void updateDbCredentials(String username, String password, Enumeration.Value database) {
        Option<File> option = ResourceUtils$.MODULE$.findFirstInClassPath(XlrConfig$.MODULE$.defaultConfigName());
        if (option instanceof Some) {
            Some some = (Some)option;
            File file = (File)some.value();
            Seq<ConfigEntry> configEntries = this.createConfigEntries(username, password, database);
            Config updatedConfig = ConfigUtils$.MODULE$.updateConfig(XlrConfig$.MODULE$.defaultConfigName(), configEntries);
            Try<Path> try_ = ConfigUtils$.MODULE$.writeToFile(file, updatedConfig);
            if (try_ instanceof Success) {
                XlrConfig$.MODULE$.reloadConfig(XlrConfig$.MODULE$.reloadConfig$default$1());
                this.updateDataSource(database, XlrConfig$.MODULE$.getInstance());
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                this.logger().error((Function0 & Serializable)() -> "Unable to update DB credentials on " + database, (Function0 & Serializable)() -> ex);
            } else {
                throw new MatchError(try_);
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<Object>)(Function0 & Serializable)() -> "Configuration file " + XlrConfig$.MODULE$.defaultConfigName() + " cannot be found in file system. Updating the DB credentials aborted!");
            return;
        }
        throw new MatchError(option);
    }

    public DbCredentialsChangeResult validateAndPublishCredentialsChangeRequest(String dbUsername, String dbPassword, String dbName) {
        Option<DbConnectingCredentialsValidator> option = this.validator(dbName);
        if (option instanceof Some) {
            Some some = (Some)option;
            DbConnectingCredentialsValidator validator = (DbConnectingCredentialsValidator)some.value();
            Try<?> try_ = validator.validate(dbUsername, dbPassword);
            if (try_ instanceof Success) {
                String encryptedPassword = PasswordEncrypter.getInstance().encrypt(dbPassword);
                this.broadcastService.broadcast(new DbCredentialsChangeRequested(dbUsername, encryptedPassword, XlrDatabase$.MODULE$.withName(dbName)), true);
                return new DbCredentialsChangeResult(true, DbCredentialsService$.MODULE$.successMessage(dbName));
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                this.logger().error((Function0 & Serializable)() -> "Invalid db credentials. Update did not happen.", (Function0 & Serializable)() -> ex);
                return new DbCredentialsChangeResult(false, DbCredentialsService$.MODULE$.invalidCredentialsMessage(dbName, ex.getMessage()));
            }
            throw new MatchError(try_);
        }
        if (None$.MODULE$.equals(option)) {
            return new DbCredentialsChangeResult(false, DbCredentialsService$.MODULE$.invalidDbNameMessage(dbName));
        }
        throw new MatchError(option);
    }

    private void updateDataSource(Enumeration.Value database, XlrConfig config) {
        Enumeration.Value value = database;
        Enumeration.Value value2 = XlrDatabase$.MODULE$.REPOSITORY();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Try<BoxedUnit> try_ = this.setNewCredentialsOn(this.xlrRepositoryDataSource, config.xlrRepositoryUsername(), config.xlrRepositoryPassword());
            if (try_ instanceof Success) {
                if (XlCluster$.MODULE$.getXlClusterProvider().isDefined()) {
                    ClusterConfig clusterConfig = XlrConfig$.MODULE$.getInstance().cluster();
                    ((XlClusterProvider)XlCluster$.MODULE$.getXlClusterProvider().get()).doWithDatasource((Function1 & Serializable)dataSource -> {
                        DbCredentialsService.$anonfun$updateDataSource$1(this, clusterConfig, dataSource);
                        return BoxedUnit.UNIT;
                    });
                }
                this.logger().info((Function0 & Serializable)() -> "Repository database credentials successfully updated");
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                this.logger().warn((Function0 & Serializable)() -> "Error updating repository DB credentials", (Function0 & Serializable)() -> exception);
            } else {
                throw new MatchError(try_);
            }
            return;
        }
        Enumeration.Value value4 = XlrDatabase$.MODULE$.ARCHIVE();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            Try<BoxedUnit> try_ = this.setNewCredentialsOn(this.reportingDataSource, config.reportingUsername(), config.reportingPassword());
            if (try_ instanceof Success) {
                this.logger().info((Function0 & Serializable)() -> "Archive database credentials successfully updated");
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                this.logger().warn((Function0 & Serializable)() -> "Error updating archive DB credentials", (Function0 & Serializable)() -> exception);
            } else {
                throw new MatchError(try_);
            }
            return;
        }
        throw new MatchError((Object)value);
    }

    private Option<DbConnectingCredentialsValidator> validator(String dbNameString) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> XlrDatabase$.MODULE$.withName(dbNameString));
        if (try_ instanceof Success) {
            Enumeration.Value dbName;
            Success success = (Success)try_;
            Enumeration.Value value = dbName = (Enumeration.Value)success.value();
            Enumeration.Value value2 = XlrDatabase$.MODULE$.REPOSITORY();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                return new Some((Object)new RepositoryCredentialsValidator(XlrConfig$.MODULE$.getInstance().xlrRepositoryJdbcUrl()));
            }
            Enumeration.Value value4 = XlrDatabase$.MODULE$.ARCHIVE();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                return new Some((Object)new ArchiveCredentialsValidator(XlrConfig$.MODULE$.getInstance().reportingUrl()));
            }
            throw new MatchError((Object)value);
        }
        if (try_ instanceof Failure) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    private Try<BoxedUnit> setNewCredentialsOn(HikariDataSource dataSource, String dbUsername, String dbPassword) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            dataSource.getHikariPoolMXBean().suspendPool();
            dataSource.getHikariConfigMXBean().setUsername(dbUsername);
            dataSource.getHikariConfigMXBean().setPassword(dbPassword);
            dataSource.getHikariPoolMXBean().softEvictConnections();
            dataSource.getHikariPoolMXBean().resumePool();
        });
    }

    private Seq<ConfigEntry> createConfigEntries(String username, String password, Enumeration.Value database) {
        Enumeration.Value value = database;
        Enumeration.Value value2 = XlrDatabase$.MODULE$.REPOSITORY();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            ConfigEntry usernameEntry = new ConfigEntry(DbCredentialsService$.MODULE$.databaseUserConfigPath(), username);
            ConfigEntry passwordEntry = new ConfigEntry(DbCredentialsService$.MODULE$.databasePasswordConfigPath(), password);
            return new .colon.colon((Object)usernameEntry, (List)new .colon.colon((Object)passwordEntry, (List)Nil$.MODULE$));
        }
        Enumeration.Value value4 = XlrDatabase$.MODULE$.ARCHIVE();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            ConfigEntry usernameEntry = new ConfigEntry(DbCredentialsService$.MODULE$.reportingUserConfigPath(), username);
            ConfigEntry passwordEntry = new ConfigEntry(DbCredentialsService$.MODULE$.reportingPasswordConfigPath(), password);
            return new .colon.colon((Object)usernameEntry, (List)new .colon.colon((Object)passwordEntry, (List)Nil$.MODULE$));
        }
        throw new RuntimeException("Unable to update " + database + " credentials");
    }

    public static final /* synthetic */ void $anonfun$updateDataSource$1(DbCredentialsService $this, ClusterConfig clusterConfig$1, HikariDataSource dataSource) {
        Try<BoxedUnit> try_ = $this.setNewCredentialsOn(dataSource, clusterConfig$1.membership().datasource().username(), clusterConfig$1.membership().datasource().password());
        if (try_ instanceof Success) {
            $this.logger().info((Function0 & Serializable)() -> "Cluster membership database credentials successfully updated");
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            $this.logger().warn((Function0 & Serializable)() -> "Error updating cluster membership database credentials", (Function0 & Serializable)() -> exception);
            return;
        }
        throw new MatchError(try_);
    }

    public DbCredentialsService(HikariDataSource xlrRepositoryDataSource, HikariDataSource reportingDataSource, BroadcastService broadcastService) {
        this.xlrRepositoryDataSource = xlrRepositoryDataSource;
        this.reportingDataSource = reportingDataSource;
        this.broadcastService = broadcastService;
        Logging.$init$((Logging)this);
    }
}

