package com.xebialabs.xlrelease.security;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.stereotype.Service;

import com.xebialabs.xlrelease.repository.CustomPersistentTokenRepository;

@Service
public class SessionService {
    private final SessionRegistry sessionRegistry;

    private final CustomPersistentTokenRepository customPersistentTokenRepository;

    @Autowired
    public SessionService(SessionRegistry sessionRegistry, CustomPersistentTokenRepository customPersistentTokenRepository) {
        this.sessionRegistry = sessionRegistry;
        this.customPersistentTokenRepository = customPersistentTokenRepository;
    }

    public void disconnect(String username) {
        for (SessionInformation session : sessionRegistry.getAllSessions(username, false)) {
            session.expireNow();
        }
        customPersistentTokenRepository.removeUserTokens(username);
    }
}
