package com.xebialabs.xlrelease.export;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Release;

import static com.google.common.io.ByteStreams.copy;

class TemplateExportHelper {
    static void addAttachments(Release template, ZipOutputStream zipOutputStream) throws IOException {
        for (Attachment attachment : template.getAttachments()) {
            addAttachment(zipOutputStream, attachment);
        }
    }

    public static void addAttachment(final ZipOutputStream zipOutputStream, final Attachment attachment) throws IOException {
        String exportFilename = attachment.getExportFilename();
        zipOutputStream.putNextEntry(new ZipEntry(exportFilename));
        try (InputStream inputStream = attachment.getFile().getInputStream()) {
            copy(inputStream, zipOutputStream);
        }
        zipOutputStream.closeEntry();
    }
}
