/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views.converters;

import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.views.ReleaseExtensionView;
import com.xebialabs.xlrelease.views.converters.ReleaseExtensionViewConverter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReleaseExtensionsViewConverter {
    private Map<Class<? extends ReleaseExtension>, ReleaseExtensionViewConverter> releaseExtensionViewConvertersPerType = new HashMap<Class<? extends ReleaseExtension>, ReleaseExtensionViewConverter>();

    public ReleaseExtensionView toView(ReleaseExtension releaseExtension) {
        return this.getConverterForClass(releaseExtension.getClass()).toView(releaseExtension);
    }

    @Autowired(required=false)
    public void setReleaseExtensionViewConverters(List<? extends ReleaseExtensionViewConverter<? extends ReleaseExtension, ? extends ReleaseExtensionView>> releaseExtensionViewConverters) {
        Optional.ofNullable(releaseExtensionViewConverters).ifPresent(converters -> converters.forEach(converter -> {
            Class releaseExtensionClass = converter.getReleaseExtensionClass();
            if (this.releaseExtensionViewConvertersPerType.containsKey(releaseExtensionClass)) {
                throw new IllegalStateException(MessageFormat.format("Two view converters were registered for release extension {0}", releaseExtensionClass));
            }
            this.releaseExtensionViewConvertersPerType.put(releaseExtensionClass, (ReleaseExtensionViewConverter)converter);
        }));
    }

    private ReleaseExtensionViewConverter getConverterForClass(Class<? extends ReleaseExtension> releaseExtensionClass) {
        ReleaseExtensionViewConverter converter = this.releaseExtensionViewConvertersPerType.get(releaseExtensionClass);
        if (Objects.isNull(converter)) {
            throw new IllegalStateException(MessageFormat.format("ReleaseExtensionViewConverter is not defined for release extension {0}", releaseExtensionClass));
        }
        return converter;
    }
}

