package com.xebialabs.xlrelease.upgrade

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry._
import com.xebialabs.deployit.plugin.api.reflect.{Descriptor, Type}
import com.xebialabs.deployit.server.api.upgrade.RepositoryInitialization
import com.xebialabs.xlrelease.configuration.{ArchivingSettings, PollingSettings, ReportsSettings}
import com.xebialabs.xlrelease.domain.BaseConfiguration
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.ClassNameToString
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired

class SettingsInitializer @Autowired()(configurationRepository: ConfigurationRepository)
  extends RepositoryInitialization with Logging with ClassNameToString {

  override def getComponent: String = XL_RELEASE_COMPONENT

  override def doInitialize(): Unit = {
    logger.debug("Initializing default settings")
    createConfiguration(ArchivingSettings.ARCHIVING_SETTINGS_ID, classOf[ArchivingSettings])
    createConfiguration(PollingSettings.POLLING_SETTINGS_ID, classOf[PollingSettings])
    createConfiguration(ReportsSettings.REPORTS_SETTINGS_ID, classOf[ReportsSettings])
  }

  private def createConfiguration[C <: BaseConfiguration](id: String, `type`: Class[C]): Unit = {
    val descriptor: Descriptor = getDescriptor(Type.valueOf(`type`))
    val ci: C = descriptor.newInstance(id)
    logger.debug(s"Creating CI: $id")
    configurationRepository.create(ci)
  }
}
