package com.xebialabs.xlrelease.features.settings

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.deployit.plugin.api.validation
import com.xebialabs.xlrelease.configuration.FeatureSettings
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import scala.beans.BeanProperty


@Metadata(label = "Script execution backpressure settings",
  description = "Script execution backpressure delays script execution when system is under load.")
class ScriptBackpressureFeatureSettings extends FeatureSettings {
  @BeanProperty
  @XLProperty(defaultValue = "Incubating", isTransient = true, hidden = true, readonly = true) // or that other
  var category: String = _

  @BeanProperty
  @XLProperty(label = "Enable", description = "Enable script execution backpressure delay", category = "input", defaultValue = "true")
  var enabled: Boolean = _

  @BeanProperty
  @XLProperty(label = "Response threshold",
    description = "Response threshold in milliseconds",
    defaultValue = "100",
    category = "input",
    isTransient = true,
    hidden = true)
  @validation.Range(minimum = 100, maximum = 10000)
  var responseThresholdMs: Int = _

  @BeanProperty
  @XLProperty(label = "Sleep duration",
    description = "Sleep duration in milliseconds if threshold is reached",
    defaultValue = "1000",
    category = "input",
    isTransient = true,
    hidden = true)
  @validation.Range(minimum = 500, maximum = 10000)
  var sleepDurationMs: Int = _

  @BeanProperty
  @XLProperty(label = "Response threshold ratio",
    description = "Response threshold ratio",
    defaultValue = "30",
    category = "input",
    isTransient = true,
    hidden = true)
  @validation.Range(minimum = 10, maximum = 100)
  var responseThresholdRatio: Int = _

  @BeanProperty
  @XLProperty(label = "Warning threshold",
    description = "Warning threshold in milliseconds",
    defaultValue = "60000",
    category = "input",
    isTransient = true,
    hidden = true)
  @validation.Range(minimum = 10000, maximum = 300000)
  var warningThresholdMs: Int = _

}
