/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.workers;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.builder.ReleaseBuilder;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.CreatedFromCreateReleaseTask;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.events.ReleaseStartedFromCreateReleaseTaskEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.IdType;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.scheduler.workers.Worker;
import com.xebialabs.xlrelease.script.EncryptionHelper$;
import com.xebialabs.xlrelease.script.TaskSoftReference;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.UsernamePassword;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.security.authentication.AuthenticationService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import scala.Function0;
import scala.Function1;
import scala.Tuple4;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00055gaB\u000b\u0017!\u0003\r\t!\t\u0005\u0006a\u0001!\t!\r\u0005\u0006k\u00011\tA\u000e\u0005\u0006{\u00011\tA\u0010\u0005\u0006\u000b\u00021\tA\u0012\u0005\u0006\u001b\u00021\tA\u0014\u0005\u0006%\u00021\ta\u0015\u0005\u00069\u00021\t!\u0018\u0005\u0006E\u00021\ta\u0019\u0005\u0006O\u0002!\t\u0001\u001b\u0005\b\u0003/\u0001A\u0011BA\r\u0011\u001d\tY\u0004\u0001C\u0005\u0003{Aq!a\u0013\u0001\t\u0013\ti\u0005C\u0004\u0002R\u0001!I!a\u0015\t\u000f\u0005]\u0003\u0001\"\u0003\u0002Z!9\u0011q\u000b\u0001\u0005\n\u0005\r\u0004bBAI\u0001\u0011%\u00111\u0013\u0005\b\u00037\u0003A\u0011BAO\u0011\u001d\tI\u000b\u0001C\u0005\u0003WCq!!-\u0001\t\u0013\t\u0019\fC\u0004\u0002<\u0002!I!!0\u0003-\r\u0013X-\u0019;f%\u0016dW-Y:f)\u0006\u001c8\u000eT8hS\u000eT!a\u0006\r\u0002\u000f]|'o[3sg*\u0011\u0011DG\u0001\ng\u000eDW\rZ;mKJT!a\u0007\u000f\u0002\u0013ad'/\u001a7fCN,'BA\u000f\u001f\u0003%AXMY5bY\u0006\u00147OC\u0001 \u0003\r\u0019w.\\\u0002\u0001'\r\u0001!\u0005\u000b\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005%rS\"\u0001\u0016\u000b\u0005-b\u0013!B:mMRR'\"A\u0017\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\f\u0016\u0003\u000f1{wmZ5oO\u00061A%\u001b8ji\u0012\"\u0012A\r\t\u0003GMJ!\u0001\u000e\u0013\u0003\tUs\u0017\u000e^\u0001\tKZ,g\u000e\u001e\"vgV\tq\u0007\u0005\u00029w5\t\u0011H\u0003\u0002;5\u00051QM^3oiNL!\u0001P\u001d\u0003#ac%+\u001a7fCN,WI^3oi\n+8/A\nsK2,\u0017m]3BGR|'oU3sm&\u001cW-F\u0001@!\t\u00015)D\u0001B\u0015\t\u0011%$\u0001\u0004bGR|'o]\u0005\u0003\t\u0006\u00131CU3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\faB]3mK\u0006\u001cXmU3sm&\u001cW-F\u0001H!\tA5*D\u0001J\u0015\tQ%$A\u0004tKJ4\u0018nY3\n\u00051K%A\u0004*fY\u0016\f7/Z*feZL7-Z\u0001\fG&LEmU3sm&\u001cW-F\u0001P!\tA\u0005+\u0003\u0002R\u0013\nY1)[%e'\u0016\u0014h/[2f\u0003U\tW\u000f\u001e5f]RL7-\u0019;j_:\u001cVM\u001d<jG\u0016,\u0012\u0001\u0016\t\u0003+jk\u0011A\u0016\u0006\u0003/b\u000ba\"Y;uQ\u0016tG/[2bi&|gN\u0003\u0002Z5\u0005A1/Z2ve&$\u00180\u0003\u0002\\-\n)\u0012)\u001e;iK:$\u0018nY1uS>t7+\u001a:wS\u000e,\u0017!\u00059fe6L7o]5p]\u000eCWmY6feV\ta\f\u0005\u0002`A6\t\u0001,\u0003\u0002b1\n\t\u0002+\u001a:nSN\u001c\u0018n\u001c8DQ\u0016\u001c7.\u001a:\u0002\u001d\r|W.\\3oiN+'O^5dKV\tA\r\u0005\u0002IK&\u0011a-\u0013\u0002\u000f\u0007>lW.\u001a8u'\u0016\u0014h/[2f\u0003%\u0019H/\u0019:u)\u0006\u001c8\u000e\u0006\u0002j{B\u0011!N\u001f\b\u0003Wbt!\u0001\\<\u000f\u000554hB\u00018v\u001d\tyGO\u0004\u0002qg6\t\u0011O\u0003\u0002sA\u00051AH]8pizJ\u0011aH\u0005\u0003;yI!a\u0007\u000f\n\u0005eQ\u0012BA\f\u0019\u0013\tIh#\u0001\u0004X_J\\WM]\u0005\u0003wr\u0014\u0001e\u0011:fCR,'+\u001a7fCN,G+Y:l\u000bb,7-\u001e;j_:\u0014Vm];mi*\u0011\u0011P\u0006\u0005\u0006}&\u0001\ra`\u0001\bi\u0006\u001c8NU3g!\u0019\t\t!a\u0002\u0002\f5\u0011\u00111\u0001\u0006\u0004\u0003\u000bQ\u0012AB:de&\u0004H/\u0003\u0003\u0002\n\u0005\r!!\u0005+bg.\u001cvN\u001a;SK\u001a,'/\u001a8dKB!\u0011QBA\n\u001b\t\tyAC\u0002\u0002\u0012i\ta\u0001Z8nC&t\u0017\u0002BA\u000b\u0003\u001f\u0011\u0011c\u0011:fCR,'+\u001a7fCN,G+Y:l\u0003A\u0019'/Z1uKN+(MU3mK\u0006\u001cX\r\u0006\u0003\u0002\u001c\u0005]\"cBA\u000fS\u0006\u0005\u0012q\u0005\u0004\u0007\u0003?\u0001\u0001!a\u0007\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0007\r\n\u0019#C\u0002\u0002&\u0011\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002*\u0005MRBAA\u0016\u0015\u0011\ti#a\f\u0002\u0005%|'BAA\u0019\u0003\u0011Q\u0017M^1\n\t\u0005U\u00121\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\b\u0003sQ\u0001\u0019AA\u0006\u0003\u0011!\u0018m]6\u0002\u001fM$\u0018M\u001d;Tk\n\u0014V\r\\3bg\u0016$b!a\u0007\u0002@\u0005\u0005\u0003bBA\u001d\u0017\u0001\u0007\u00111\u0002\u0005\b\u0003\u0007Z\u0001\u0019AA#\u0003)\u0019XO\u0019*fY\u0016\f7/\u001a\t\u0005\u0003\u001b\t9%\u0003\u0003\u0002J\u0005=!a\u0002*fY\u0016\f7/Z\u0001\u001fm\u0006d\u0017\u000eZ1uK\u000e\u0013X-\u0019;f%\u0016dW-Y:f%\u0016\u001cWO]:j_:$2AMA(\u0011\u001d\tI\u0004\u0004a\u0001\u0003\u0017\t!D^1mS\u0012\fG/\u001a*fcVL'/\u001a3Qe>\u0004XM\u001d;jKN$2AMA+\u0011\u001d\tI$\u0004a\u0001\u0003\u0017\t\u0001c\u00195fG.\u0004VM]7jgNLwN\\:\u0015\t\u0005m\u0013\u0011\r\t\u0004?\u0006u\u0013bAA01\n\u0001Rk]3s]\u0006lW\rU1tg^|'\u000f\u001a\u0005\b\u0003sq\u0001\u0019AA\u0006)!\tY&!\u001a\u0002h\u0005m\u0004bBA\u001d\u001f\u0001\u0007\u00111\u0002\u0005\b\u0003Sz\u0001\u0019AA6\u0003%\u0011X\r\\3bg\u0016LE\r\u0005\u0003\u0002n\u0005Ud\u0002BA8\u0003c\u0002\"\u0001\u001d\u0013\n\u0007\u0005MD%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003o\nIH\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003g\"\u0003bBA?\u001f\u0001\u0007\u0011qP\u0001\u0013e\u0016\fX/\u001b:fIB+'/\\5tg&|g\u000e\u0005\u0003\u0002\u0002\u00065UBAAB\u0015\u0011\t))a\"\u0002\u0015A,'/\\5tg&|gNC\u0002Z\u0003\u0013S1!a#\u001d\u0003!!W\r\u001d7ps&$\u0018\u0002BAH\u0003\u0007\u0013!\u0002U3s[&\u001c8/[8o\u00035\u0019'/Z1uKJ+G.Z1tKR1\u0011QIAK\u0003/Cq!!\u000f\u0011\u0001\u0004\tY\u0001C\u0004\u0002\u001aB\u0001\r!a\u0017\u0002%M\u001c'/\u001b9u+N,'O\\1nKB\u000b7o]\u0001\rgR\f'\u000f\u001e*fY\u0016\f7/\u001a\u000b\u0007\u0003?\u000b)+a*\u0011\u0007\r\n\t+C\u0002\u0002$\u0012\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002:E\u0001\r!a\u0003\t\u000f\u0005\r\u0013\u00031\u0001\u0002F\u0005aB\u000f\u001b:po&3W*\u0019=D_:\u001cWO\u001d:f]\u000eL(+Z1dQ\u0016$Gc\u0001\u001a\u0002.\"9\u0011q\u0016\nA\u0002\u0005\u0015\u0013a\u0003:p_R\u0014V\r\\3bg\u0016\f1dZ3u'V\u0014'+\u001a7fCN,\u0007+\u0019:b[N4%o\\7UCN\\GCBA#\u0003k\u000b9\fC\u0004\u0002:M\u0001\r!a\u0003\t\u000f\u0005e6\u00031\u0001\u0002F\u0005\u00112/\u001e2SK2,\u0017m]3UK6\u0004H.\u0019;f\u000399W\r\u001e*fY\u0016\f7/\u001a'j].$B!a0\u0002JB!\u0011\u0011YAd\u001b\t\t\u0019M\u0003\u0003\u0002F\u0006=\u0012\u0001\u00027b]\u001eLA!a\u001e\u0002D\"9\u00111\u001a\u000bA\u0002\u0005\u0015\u0013a\u0002:fY\u0016\f7/\u001a")
public interface CreateReleaseTaskLogic
extends Logging {
    public XLReleaseEventBus eventBus();

    public ReleaseActorService releaseActorService();

    public ReleaseService releaseService();

    public CiIdService ciIdService();

    public AuthenticationService authenticationService();

    public PermissionChecker permissionChecker();

    public CommentService commentService();

    public static /* synthetic */ Worker.CreateReleaseTaskExecutionResult startTask$(CreateReleaseTaskLogic $this, TaskSoftReference taskRef) {
        return $this.startTask(taskRef);
    }

    default public Worker.CreateReleaseTaskExecutionResult startTask(TaskSoftReference<CreateReleaseTask> taskRef) {
        Worker.CreateReleaseTaskExecutionResult createReleaseTaskExecutionResult;
        try {
            CreateReleaseTask task = taskRef.get();
            this.validateRequiredProperties(task);
            this.validateCreateReleaseRecursion(task);
            createReleaseTaskExecutionResult = this.createSubRelease(task);
        }
        catch (Exception ex) {
            String message = String.format("Exception occurred while creating a release. Reason: %s.", ex.getMessage());
            this.logger().error((Function0 & Serializable)() -> message, (Function0 & Serializable)() -> ex);
            createReleaseTaskExecutionResult = new Worker.CreateReleaseTaskExecutionResulCreateReleaseFailure(taskRef.getTaskId(), taskRef.getExecutionId(), ex.getMessage());
        }
        return createReleaseTaskExecutionResult;
    }

    private Worker.CreateReleaseTaskExecutionResult createSubRelease(CreateReleaseTask task) {
        UsernamePassword scriptUserPass = this.checkPermissions(task);
        Release subRelease = this.createRelease(task, scriptUserPass);
        boolean startSubReleaseOnCreation = task.getStartRelease();
        if (startSubReleaseOnCreation) {
            return this.startSubRelease(task, subRelease);
        }
        return new Worker.CreateReleaseTaskExecutionResultSuccess(task.getId(), task.getExecutionId(), subRelease.getId());
    }

    private Worker.CreateReleaseTaskExecutionResult startSubRelease(CreateReleaseTask task, Release subRelease) {
        Worker.CreateReleaseTaskExecutionResult createReleaseTaskExecutionResult;
        block3: {
            try {
                this.checkPermissions(task, subRelease.getId(), XLReleasePermissions.START_RELEASE);
                boolean isStarted = this.startRelease(task, subRelease);
                if (isStarted) {
                    createReleaseTaskExecutionResult = new Worker.CreateReleaseTaskExecutionResultSuccess(task.getId(), task.getExecutionId(), subRelease.getId());
                    break block3;
                }
                String message = String.format("Release '%s' could not be started", subRelease.getTitle());
                createReleaseTaskExecutionResult = new Worker.CreateReleaseTaskExecutionResultStartReleaseFailure(task.getId(), task.getExecutionId(), subRelease.getId(), message);
            }
            catch (Exception ex) {
                String message = String.format("Release '%s' could not be started. Reason: '%s'", subRelease.getTitle(), ex.getMessage());
                createReleaseTaskExecutionResult = new Worker.CreateReleaseTaskExecutionResultStartReleaseFailure(task.getId(), task.getExecutionId(), subRelease.getId(), message);
            }
        }
        return createReleaseTaskExecutionResult;
    }

    private void validateCreateReleaseRecursion(CreateReleaseTask task) {
        if (Strings.isNotBlank((String)task.getTemplateIdVariable()) && Strings.isNotBlank((String)task.getRelease().getOriginTemplateId())) {
            String string = task.getRelease().getOriginTemplateId();
            String string2 = task.getTemplateId();
            Preconditions.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (Object)"The template that will be used to create a new release must be different from the template used to create the current release.");
            return;
        }
    }

    private void validateRequiredProperties(CreateReleaseTask task) {
        Preconditions.checkArgument((boolean)Strings.isNotBlank((String)task.getNewReleaseTitle()), (Object)"Title of the release to be created cannot be empty.");
        String errorMessageTemplate = Strings.isNotBlank((String)task.getTemplateIdVariable()) ? "Template that will be used to create a release couldn't be derived from variable " + task.getTemplateIdVariable() : "Template that will be used to create a release must be specified.";
        Preconditions.checkArgument((boolean)Strings.isNotBlank((String)task.getTemplateId()), (Object)errorMessageTemplate);
        Preconditions.checkArgument((boolean)this.releaseService().exists(task.getTemplateId()), (Object)("Template provided in variable " + task.getTemplateIdVariable() + " must be a valid template id."));
    }

    private UsernamePassword checkPermissions(CreateReleaseTask task) {
        return this.checkPermissions(task, task.getTemplateId(), null);
    }

    private UsernamePassword checkPermissions(CreateReleaseTask task, String releaseId, Permission requiredPermission) {
        UsernamePassword usernamePass = null;
        try {
            usernamePass = this.authenticationService().loginScriptUser((Task)task);
            String templateId = this.releaseService().getFullId(Ids.getFolderlessId((String)task.getTemplateId()));
            String targetFolderId = !Ids.isNullId((String)task.getFolderId()) ? task.getFolderId() : Ids.findFolderId((String)templateId);
            this.permissionChecker().checkIsAllowedToCreateReleaseFromTemplate(templateId, targetFolderId);
            if (requiredPermission != null) {
                this.permissionChecker().check(requiredPermission, releaseId);
            }
        }
        finally {
            this.authenticationService().logoutScriptUser();
        }
        return usernamePass;
    }

    private Release createRelease(CreateReleaseTask task, UsernamePassword scriptUsernamePass) {
        Release subReleaseTemplate = this.releaseService().findById(task.getTemplateId());
        Release releaseMetadata = this.getSubReleaseParamsFromTask(task, subReleaseTemplate);
        String rootReleaseId = Optional.ofNullable(task.getRelease().getRootReleaseId()).orElse(task.getRelease().getId());
        try {
            this.throwIfMaxConcurrencyReached(this.releaseService().findByIdIncludingArchived(rootReleaseId));
        }
        catch (NotFoundException ex) {
            this.logger().debug((Function0 & Serializable)() -> String.format("Root release not found. Missing release max concurrency check. Reason: %s.", ex.getMessage()), (Function0 & Serializable)() -> ex);
        }
        releaseMetadata.setRootReleaseId(rootReleaseId);
        releaseMetadata.setOwner(scriptUsernamePass.username());
        releaseMetadata.setScriptUsername(scriptUsernamePass.username());
        releaseMetadata.setScriptUserPassword(scriptUsernamePass.password());
        EncryptionHelper$.MODULE$.decrypt((ConfigurationItem)releaseMetadata);
        Release subRelease = this.releaseService().createFromTemplate(task.getTemplateId(), releaseMetadata, task.getFolderId());
        this.commentService().create((Task)task, String.format("Created release %s.", this.getReleaseLink(subRelease)), User.AUTHENTICATED_USER, true);
        this.eventBus().publish((XLReleaseEvent)new ReleaseCreatedEvent(subRelease, (ReleaseCreationSource)new CreatedFromCreateReleaseTask(task, subReleaseTemplate.getId())));
        return subRelease;
    }

    private boolean startRelease(CreateReleaseTask task, Release subRelease) {
        boolean hasBeenStarted;
        block0: {
            Release startedRelease = this.releaseActorService().startRelease(subRelease.getId(), User.SYSTEM);
            hasBeenStarted = startedRelease.getStatus().hasBeenStarted();
            if (!hasBeenStarted) break block0;
            this.commentService().create(task.getId(), String.format("Started release %s.", this.getReleaseLink(startedRelease)), User.AUTHENTICATED_USER, true);
            this.eventBus().publish((XLReleaseEvent)new ReleaseStartedFromCreateReleaseTaskEvent(task, subRelease));
        }
        return hasBeenStarted;
    }

    private void throwIfMaxConcurrencyReached(Release rootRelease) {
        int maxConcurrency = rootRelease.getMaxConcurrentReleases();
        List<Release> spawnedReleases = this.releaseService().findSpawnedReleases(rootRelease.getId(), maxConcurrency);
        int rootCount = rootRelease.isDefunct() ? 0 : 1;
        int currentlyRunning = spawnedReleases.size() + rootCount;
        this.logger().debug((Function0 & Serializable)() -> new Tuple4((Object)"maxConcurrency: {}, currently running releases ({}): {}", (Object)BoxesRunTime.boxToInteger((int)maxConcurrency), (Object)BoxesRunTime.boxToInteger((int)currentlyRunning), (Object)spawnedReleases));
        if (currentlyRunning >= maxConcurrency) {
            throw new IllegalStateException(String.format("Exceeded maximum number of concurrent releases created from %s. Current maximum is %s. This value can be configured in deployit-defaults.properties: xlrelease.Release.maxConcurrentReleases", rootRelease.getTitle(), BoxesRunTime.boxToInteger((int)maxConcurrency)));
        }
    }

    private Release getSubReleaseParamsFromTask(CreateReleaseTask task, Release subReleaseTemplate) {
        Map templateVariables = VariableHelper$.MODULE$.indexByKey(subReleaseTemplate.getVariables());
        List variablesShownOnReleaseStart = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(task.getTemplateVariables()).asScala().filter((Function1 & Serializable)variable -> BoxesRunTime.boxToBoolean((boolean)CreateReleaseTaskLogic.$anonfun$getSubReleaseParamsFromTask$1(templateVariables, variable)))).asJava();
        List variables = VariableHelper$.MODULE$.fillVariableValues(subReleaseTemplate.getVariables(), variablesShownOnReleaseStart);
        ArrayList subReleaseTags = new ArrayList(subReleaseTemplate.getTags());
        subReleaseTags.addAll(task.getReleaseTags());
        Release release = ReleaseBuilder.newRelease().withVariables(variables).withOriginTemplateId(task.getTemplateId()).withTitle(task.getNewReleaseTitle()).withOwner(task.getRelease().getScriptUsername()).withScriptUsername(task.getRelease().getScriptUsername()).withScriptUserPassword(task.getRelease().getScriptUserPassword()).withDisableNotifications(task.getRelease().isDisableNotifications()).withTags(subReleaseTags).build();
        release.setProperty("riskProfile", task.getProperty("riskProfile"));
        this.releaseService().setDatesFromTemplate(release, subReleaseTemplate);
        release.setStartedFromTaskId(task.getId());
        release.setAbortOnFailure(subReleaseTemplate.isAbortOnFailure());
        release.setAllowPasswordsInAllFields(subReleaseTemplate.isAllowPasswordsInAllFields());
        VariablePersistenceHelper$.MODULE$.fixUpVariableIds(release.getId(), release.getVariables(), this.ciIdService());
        return release;
    }

    private String getReleaseLink(Release release) {
        return String.format("[%s](#/releases/%s)", release.getTitle(), IdType.DOMAIN.convertToViewId(release.getId()));
    }

    public static /* synthetic */ boolean $anonfun$getSubReleaseParamsFromTask$1(Map templateVariables$1, Variable variable) {
        return templateVariables$1.containsKey(variable.getKey()) && ((Variable)templateVariables$1.get(variable.getKey())).getShowOnReleaseStart();
    }

    public static void $init$(CreateReleaseTaskLogic $this) {
    }
}

