/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.runner.JobRunner;
import com.xebialabs.xlrelease.repository.JobRunnerRepository;
import com.xebialabs.xlrelease.scheduler.DefaultJobQueue;
import com.xebialabs.xlrelease.scheduler.FailJob;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobProvider;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.JobRunnerQueue;
import com.xebialabs.xlrelease.scheduler.RunnerRegistry;
import com.xebialabs.xlrelease.scheduler.ScriptBackpressure;
import com.xebialabs.xlrelease.scheduler.StopWorkerThread;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.domain.LocalJobRunner$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.slf4j.Marker;
import org.springframework.context.annotation.Primary;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Primary
@Component
@ScalaSignature(bytes="\u0006\u0005\t-a\u0001B\u0010!\u0001%B\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\r\u0002\u0011)\u0019!C\u0001\u000f\"Aa\n\u0001B\u0001B\u0003%\u0001\n\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003Q\u0011!1\u0006A!A!\u0002\u00139\u0006\"\u0002.\u0001\t\u0003Y\u0006bB1\u0001\u0005\u0004%IA\u0019\u0005\b\u0003#\u0001\u0001\u0015!\u0003d\u0011\u001d\t\u0019\u0002\u0001C!\u0003+Aq!!\f\u0001\t\u0003\ny\u0003C\u0004\u00024\u0001!)%!\u000e\t\u000f\u0005U\u0003\u0001\"\u0003\u0002X!9\u0011q\f\u0001\u0005\n\u0005\u0005\u0004bBA4\u0001\u0011\u0005\u0013\u0011\u000e\u0005\b\u0003{\u0002A\u0011BA@\u0011\u001d\t)\t\u0001C\u0005\u0003\u000fCq!!'\u0001\t\u0003\nY\nC\u0004\u0002 \u0002!\t%!)\t\u000f\u0005\u0015\u0006\u0001\"\u0011\u0002(\"9\u00111\u0016\u0001\u0005B\u00055\u0006bBAY\u0001\u0011\u0005\u00131\u0017\u0005\b\u0003o\u0003A\u0011IA]\u0011\u001d\ti\f\u0001C!\u0003\u007fCq!!1\u0001\t\u0003\ny\fC\u0004\u0002D\u0002!\t%!2\t\u000f\u0005\u001d\u0007\u0001\"\u0011\u0002J\"9\u0011\u0011\u001b\u0001\u0005\n\u0005}\u0006bBAj\u0001\u0011%\u0011Q\u001b\u0005\b\u00033\u0004A\u0011BAn\u0011\u001d\ty\u000e\u0001C\u0005\u0003C\u0014qcQ1qC\nLG.\u001b;z\u0003^\f'/\u001a&pEF+X-^3\u000b\u0005\u0005\u0012\u0013!C:dQ\u0016$W\u000f\\3s\u0015\t\u0019C%A\u0005yYJ,G.Z1tK*\u0011QEJ\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aJ\u0001\u0004G>l7\u0001A\n\u0007\u0001)\u0002Dg\u000e\u001e\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\r\u0005s\u0017PU3g!\t\t$'D\u0001!\u0013\t\u0019\u0004E\u0001\u0005K_\n\fV/Z;f!\t\tT'\u0003\u00027A\tq!+\u001e8oKJ\u0014VmZ5tiJL\bCA\u00199\u0013\tI\u0004EA\u0006K_\n\u0004&o\u001c<jI\u0016\u0014\bCA\u001eA\u001b\u0005a$BA\u001f?\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005y\u0014\u0001C4sSjTH.\u001a3\n\u0005\u0005c$a\u0002'pO\u001eLgnZ\u0001\tU>\u0014\u0017+^3vKB\u0011\u0011\u0007R\u0005\u0003\u000b\u0002\u0012q\u0002R3gCVdGOS8c#V,W/Z\u0001\u0014U>\u0014'+\u001e8oKJ\u0014V\r]8tSR|'/_\u000b\u0002\u0011B\u0011\u0011\nT\u0007\u0002\u0015*\u00111JI\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA'K\u0005MQuN\u0019*v]:,'OU3q_NLGo\u001c:z\u0003QQwN\u0019*v]:,'OU3q_NLGo\u001c:zA\u0005\u0019\"/\u001a7fCN,\u0017i\u0019;peN+'O^5dKB\u0011\u0011\u000bV\u0007\u0002%*\u00111KI\u0001\u0007C\u000e$xN]:\n\u0005U\u0013&a\u0005*fY\u0016\f7/Z!di>\u00148+\u001a:wS\u000e,\u0017\u0001\u00042bG.\u0004(/Z:tkJ,\u0007CA\u0019Y\u0013\tI\u0006E\u0001\nTGJL\u0007\u000f\u001e\"bG.\u0004(/Z:tkJ,\u0017A\u0002\u001fj]&$h\bF\u0003];z{\u0006\r\u0005\u00022\u0001!)!I\u0002a\u0001\u0007\")aI\u0002a\u0001\u0011\")qJ\u0002a\u0001!\")aK\u0002a\u0001/\u0006a!/\u001e8oKJ\fV/Z;fgV\t1\rE\u0003eW6\fY!D\u0001f\u0015\t1w-\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001[5\u0002\tU$\u0018\u000e\u001c\u0006\u0002U\u0006!!.\u0019<b\u0013\taWMA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u00042A\\A\u0003\u001d\tywP\u0004\u0002qy:\u0011\u0011O\u001f\b\u0003eft!a\u001d=\u000f\u0005Q<X\"A;\u000b\u0005YD\u0013A\u0002\u001fs_>$h(C\u0001(\u0013\t)c%\u0003\u0002$I%\u00111PI\u0001\u0007eVtg.\u001a:\n\u0005ut\u0018A\u00023p[\u0006LgN\u0003\u0002|E%!\u0011\u0011AA\u0002\u0003\u001d\u0001\u0018mY6bO\u0016T!! @\n\t\u0005\u001d\u0011\u0011\u0002\u0002\t%Vtg.\u001a:JI*!\u0011\u0011AA\u0002!\r\t\u0014QB\u0005\u0004\u0003\u001f\u0001#A\u0004&pEJ+hN\\3s#V,W/Z\u0001\u000eeVtg.\u001a:Rk\u0016,Xm\u001d\u0011\u0002#I,w-[:uKJTuN\u0019*v]:,'\u000f\u0006\u0003\u0002\u0018\u0005u\u0001cA\u0016\u0002\u001a%\u0019\u00111\u0004\u0017\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003?I\u0001\u0019AA\u0011\u0003%QwN\u0019*v]:,'\u000f\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\rY\u0018q\u0005\u0006\u0003{\nJA!a\u000b\u0002&\tI!j\u001c2Sk:tWM]\u0001\u0014k:\u0014XmZ5ti\u0016\u0014(j\u001c2Sk:tWM\u001d\u000b\u0005\u0003/\t\t\u0004C\u0004\u0002 )\u0001\r!!\t\u0002\u0007\u001d,G\u000f\u0006\u0003\u00028\u0005\r\u0003#B\u0016\u0002:\u0005u\u0012bAA\u001eY\t1q\n\u001d;j_:\u00042!MA \u0013\r\t\t\u0005\t\u0002\u0004\u0015>\u0014\u0007BBA#\u0017\u0001\u0007Q.\u0001\u0005sk:tWM]%eQ\rY\u0011\u0011\n\t\u0005\u0003\u0017\n\t&\u0004\u0002\u0002N)\u0019\u0011q\n\u0017\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002T\u00055#a\u0002;bS2\u0014XmY\u0001\u000be\u0016\u001cXM\u001d<f\u0015>\u0014GCBA\u001c\u00033\ni\u0006C\u0004\u0002\\1\u0001\r!!\u0010\u0002\u0017A|7o]5cY\u0016TuN\u0019\u0005\u0007\u0003\u000bb\u0001\u0019A7\u0002\u000fI,7/\u001a:wKR1\u0011QHA2\u0003KBq!a\u0017\u000e\u0001\u0004\ti\u0004\u0003\u0004\u0002F5\u0001\r!\\\u0001\bG>tg-\u001b:n)\u0019\tY'!\u001d\u0002tA\u00191&!\u001c\n\u0007\u0005=DFA\u0004C_>dW-\u00198\t\r\u0005\u0015c\u00021\u0001n\u0011\u001d\t)H\u0004a\u0001\u0003o\nQA[8c\u0013\u0012\u00042A\\A=\u0013\u0011\tY(!\u0003\u0003\u000b){'-\u00133\u0002-=4g-\u001a:U_*{'MU;o]\u0016\u0014\u0018+^3vKN$B!a\u0006\u0002\u0002\"9\u00111Q\bA\u0002\u0005u\u0012a\u00016pE\u0006I\"/Z7pm\u00164%o\\7K_\n\u0014VO\u001c8feF+X-^3t)\u0011\t9\"!#\t\u000f\u0005-\u0005\u00031\u0001\u0002\u000e\u0006I\u0001O]3eS\u000e\fG/\u001a\t\u0007\u0003\u001f\u000b)*!\u0010\u000e\u0005\u0005E%bAAJO\u0006Aa-\u001e8di&|g.\u0003\u0003\u0002\u0018\u0006E%!\u0003)sK\u0012L7-\u0019;f\u0003\u0019\u0019XOY7jiR!\u0011qCAO\u0011\u001d\t\u0019)\u0005a\u0001\u0003{\tab];c[&$X\t_5ti&tw\r\u0006\u0003\u0002\u0018\u0005\r\u0006bBAB%\u0001\u0007\u0011QH\u0001\u0012gV\u0014W.\u001b;Ce>\fGmY1ti\u0016$G\u0003BA\f\u0003SCq!a!\u0014\u0001\u0004\ti$A\u0004sKBd\u0017mY3\u0015\t\u0005]\u0011q\u0016\u0005\b\u0003\u0007#\u0002\u0019AA\u001f\u0003\u00191\u0017N\\5tQR!\u0011qCA[\u0011\u001d\t)(\u0006a\u0001\u0003o\n\u0001bY1oG\u0016d\u0017J\u001a\u000b\u0005\u0003/\tY\fC\u0004\u0002\fZ\u0001\r!!$\u0002\u000bM$\u0018M\u001d;\u0015\u0005\u0005]\u0011\u0001B:u_B\f\u0011\"[:Sk:t\u0017N\\4\u0015\u0005\u0005-\u0014\u0001B:ju\u0016$\"!a3\u0011\u0007-\ni-C\u0002\u0002P2\u00121!\u00138u\u0003I\u0011XmZ5ti\u0016\u0014(j\u001c2Sk:tWM]:\u0002#\r\u0014X-\u0019;f%Vtg.\u001a:Rk\u0016,X\r\u0006\u0003\u0002\u0018\u0005]\u0007BB>\u001d\u0001\u0004\t\t#A\tsK6|g/\u001a*v]:,'/U;fk\u0016$B!a\u0006\u0002^\"110\ba\u0001\u0003C\tA#\u001e9eCR,G+Y:l'R\fG/^:MS:,G\u0003BA\f\u0003GDq!a!\u001f\u0001\u0004\ti\u0004K\u0002\u0001\u0003O\u0004B!!;\u0002x6\u0011\u00111\u001e\u0006\u0005\u0003[\fy/\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016TA!!=\u0002t\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002v\u0006\u0019qN]4\n\t\u0005e\u00181\u001e\u0002\n\u0007>l\u0007o\u001c8f]RD3\u0001AA\u007f!\u0011\tyPa\u0002\u000e\u0005\t\u0005!\u0002BA(\u0005\u0007QAA!\u0002\u0002p\u000691m\u001c8uKb$\u0018\u0002\u0002B\u0005\u0005\u0003\u0011q\u0001\u0015:j[\u0006\u0014\u0018\u0010")
public class CapabilityAwareJobQueue
implements JobQueue,
RunnerRegistry,
JobProvider,
Logging {
    private final DefaultJobQueue jobQueue;
    private final JobRunnerRepository jobRunnerRepository;
    private final ReleaseActorService releaseActorService;
    private final ScriptBackpressure backpressure;
    private final ConcurrentHashMap<String, JobRunnerQueue> runnerQueues;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        CapabilityAwareJobQueue capabilityAwareJobQueue = this;
        synchronized (capabilityAwareJobQueue) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public JobRunnerRepository jobRunnerRepository() {
        return this.jobRunnerRepository;
    }

    private ConcurrentHashMap<String, JobRunnerQueue> runnerQueues() {
        return this.runnerQueues;
    }

    @Override
    public void registerJobRunner(JobRunner jobRunner) {
        this.logger().debug((Function0 & Serializable)() -> "Going to register runner[" + jobRunner.getId() + "]");
        this.createRunnerQueue(jobRunner);
    }

    @Override
    public void unregisterJobRunner(JobRunner jobRunner) {
        this.logger().debug((Function0 & Serializable)() -> "Going to un-register runner[" + jobRunner.getId() + "]");
        this.removeRunnerQueue(jobRunner);
    }

    @Override
    public final Option<Job> get(String runnerId) {
        Option s;
        Option option;
        while ((option = (s = Option$.MODULE$.apply((Object)this.runnerQueues().get(runnerId)))) instanceof Some) {
            Some some = (Some)option;
            JobRunnerQueue runnerQueue = (JobRunnerQueue)some.value();
            boolean bl = false;
            Some some2 = null;
            Option option2 = Option$.MODULE$.apply((Object)runnerQueue.poll());
            if (option2 instanceof Some) {
                bl = true;
                some2 = (Some)option2;
                Job job = (Job)some2.value();
                if (job instanceof StopWorkerThread) {
                    return some2;
                }
            }
            if (bl) {
                Job possibleJob = (Job)some2.value();
                this.backpressure.backpressureFn(possibleJob);
                Option<Job> option3 = this.reserveJob(possibleJob, runnerId);
                if (None$.MODULE$.equals(option3)) continue;
                if (option3 instanceof Some) {
                    Some some3 = (Some)option3;
                    return some3;
                }
                throw new MatchError(option3);
            }
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)option2);
        }
        if (None$.MODULE$.equals(option)) {
            String msg = "No runner queue found for " + runnerId;
            this.logger().warn((Function0 & Serializable)() -> msg);
            throw new NotFoundException(msg, new Object[0]);
        }
        throw new MatchError((Object)option);
    }

    private Option<Job> reserveJob(Job possibleJob, String runnerId) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.reserve(possibleJob, runnerId));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Job reservedJob = (Job)success.value();
            this.logger().debug((Function0 & Serializable)() -> "giving " + reservedJob);
            this.updateTaskStatusLine(reservedJob);
            return new Some((Object)reservedJob);
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            Throwable throwable = exception;
            if (throwable instanceof OptimisticLockingFailureException) {
                this.logger().warn((Function0 & Serializable)() -> "Unable to reserve job " + possibleJob);
                return None$.MODULE$;
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                this.logger().error((Function0 & Serializable)() -> "Unexpected error", (Function0 & Serializable)() -> throwable2);
                FailJob failJob = new FailJob(possibleJob, (Option<String>)new Some((Object)throwable2.getMessage()));
                this.runnerQueues().get(LocalJobRunner$.MODULE$.getId()).offer(failJob);
                return None$.MODULE$;
            }
            throw new MatchError((Object)throwable);
        }
        throw new MatchError((Object)try_);
    }

    private Job reserve(Job possibleJob, String runnerId) {
        Job job = this.jobQueue.reserve(possibleJob, runnerId);
        this.removeFromJobRunnerQueues(x$1 -> x$1.id() == possibleJob.id());
        return job;
    }

    @Override
    public boolean confirm(String runnerId, long jobId) {
        boolean result;
        block1: {
            Tuple2<Object, Option<TaskJob<?>>> tuple2 = this.jobQueue.confirm(runnerId, jobId);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            boolean result2 = tuple2._1$mcZ$sp();
            Option taskJob = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)result2), (Object)taskJob);
            result = tuple22._1$mcZ$sp();
            Option taskJob2 = (Option)tuple22._2();
            if (!result || !taskJob2.isDefined()) break block1;
            this.updateTaskStatusLine((Job)taskJob2.get());
        }
        return result;
    }

    private void offerToJobRunnerQueues(Job job) {
        CollectionConverters$.MODULE$.IteratorHasAsScala(this.runnerQueues().values().iterator()).asScala().foreach((Function1 & Serializable)subscriber -> {
            subscriber.offer(job);
            return BoxedUnit.UNIT;
        });
    }

    private void removeFromJobRunnerQueues(Predicate<Job> predicate) {
        CollectionConverters$.MODULE$.IteratorHasAsScala(this.runnerQueues().values().iterator()).asScala().foreach((Function1 & Serializable)subscriber -> {
            subscriber.cancelIf(predicate);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void submit(Job job) {
        this.jobQueue.submit(job);
        this.updateTaskStatusLine(job);
        this.offerToJobRunnerQueues(job);
    }

    @Override
    public void submitExisting(Job job) {
        this.jobQueue.submitExisting(job);
        this.offerToJobRunnerQueues(job);
    }

    @Override
    public void submitBroadcasted(Job job) {
        this.jobQueue.submitBroadcasted(job);
        this.offerToJobRunnerQueues(job);
    }

    @Override
    public void replace(Job job) {
        this.jobQueue.replace(job);
        this.offerToJobRunnerQueues(job);
    }

    @Override
    public void finish(long jobId) {
        this.jobQueue.finish(jobId);
    }

    @Override
    public void cancelIf(Predicate<Job> predicate) {
        this.jobQueue.cancelIf(predicate);
        this.removeFromJobRunnerQueues(predicate);
    }

    @Override
    public void start() {
        this.registerJobRunners();
        this.jobQueue.start();
    }

    @Override
    public void stop() {
        this.jobQueue.stop();
    }

    @Override
    public boolean isRunning() {
        return this.jobQueue.isRunning();
    }

    @Override
    public int size() {
        return this.jobQueue.size();
    }

    private void registerJobRunners() {
        List<? extends JobRunner> jobRunners = this.jobRunnerRepository().findAll();
        jobRunners.forEach(runner -> this.createRunnerQueue((JobRunner)runner));
    }

    private void createRunnerQueue(JobRunner runner) {
        this.runnerQueues().remove(runner.getId());
        JobRunnerQueue runnerQueue = new JobRunnerQueue((Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(runner.getCapabilities()).asScala().toSet());
        this.runnerQueues().put(runner.getId(), runnerQueue);
        CollectionConverters$.MODULE$.IteratorHasAsScala(this.jobQueue.localJobs().iterator()).asScala().foreach((Function1 & Serializable)job -> {
            runnerQueue.offer(job);
            return BoxedUnit.UNIT;
        });
    }

    private void removeRunnerQueue(JobRunner runner) {
        this.runnerQueues().remove(runner.getId());
    }

    private void updateTaskStatusLine(Job job) {
        Job job2 = job;
        if (job2 instanceof TaskJob) {
            TaskJob taskJob = (TaskJob)job2;
            taskJob.jobStatusLine().foreach((Function1 & Serializable)statusLine -> {
                this.releaseActorService.updateTaskStatusLine(taskJob.taskId(), statusLine);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public CapabilityAwareJobQueue(DefaultJobQueue jobQueue, JobRunnerRepository jobRunnerRepository, ReleaseActorService releaseActorService, ScriptBackpressure backpressure) {
        this.jobQueue = jobQueue;
        this.jobRunnerRepository = jobRunnerRepository;
        this.releaseActorService = releaseActorService;
        this.backpressure = backpressure;
        Logging.$init$((Logging)this);
        this.runnerQueues = new ConcurrentHashMap();
        this.createRunnerQueue(LocalJobRunner$.MODULE$);
    }
}

