package com.xebialabs.xlrelease.scheduler.workers

import com.xebialabs.xlrelease.domain.BaseScriptTask
import com.xebialabs.xlrelease.script.ScriptService
import org.springframework.security.core.Authentication
import org.springframework.security.core.context.SecurityContextHolder

import scala.jdk.CollectionConverters._

trait ScriptServiceSupport {
  def scriptServicesList: java.util.List[ScriptService]

  val scriptServices: java.util.Map[String, ScriptService] = scriptServicesList.asScala.map(s => s.engine() -> s).toMap.asJava

  protected def scriptServiceFor(task: BaseScriptTask): ScriptService = scriptServices.get(task.getEngine)

  def withAuthentication(authentication: Authentication)(code: => Unit): Unit = {
    val previousAuthentication = SecurityContextHolder.getContext.getAuthentication
    try {
      SecurityContextHolder.getContext.setAuthentication(authentication)
      code
    } finally {
      SecurityContextHolder.getContext.setAuthentication(previousAuthentication)
    }
  }
}
