package com.xebialabs.xlrelease.repository

import java.util.concurrent.ConcurrentHashMap
import javax.ws.rs.sse.SseEventSink
import scala.collection.{concurrent, mutable}
import scala.jdk.CollectionConverters.ConcurrentMapHasAsScala

trait CiSSERepository {

  def get(taskId: String): Set[SseEventSink]

  def put(taskId: String, sink: SseEventSink): Unit

}

class InMemoryCiSSERepository extends CiSSERepository {

  private val sessions: concurrent.Map[String, mutable.Set[SseEventSink]] = new ConcurrentHashMap[String, mutable.Set[SseEventSink]].asScala

  override def get(taskId: String): Set[SseEventSink] = {
    removeClosedSinks()
    val folderLessId = Ids.getFolderlessId(taskId)
    sessions.getOrElse(folderLessId, Set.empty[SseEventSink]).toSet
  }

  override def put(taskId: String, sink: SseEventSink): Unit = {
    removeClosedSinks()
    val folderLessId = Ids.getFolderlessId(taskId)
    val taskSinks = sessions.getOrElse(folderLessId, mutable.HashSet[SseEventSink]())
    sessions.put(folderLessId, taskSinks += sink)
  }

  private def removeClosedSinks(): Unit = {
    sessions.values.foreach { set => set.filterInPlace(!_.isClosed) }
    sessions.filterInPlace { (_, set) => set.nonEmpty}
  }
}

