package com.xebialabs.xlrelease.api.utils;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

import static com.xebialabs.xlrelease.api.utils.WordUtils.convertToTitleCase;

public class AccountIdHelper {

    public static String generateAccountId(String licensedName, String serverUrl) {
        if (licensedName == null) {
            licensedName = "";
        }
        if (serverUrl == null) {
            serverUrl = "";
        }
        String accountName = convertToTitleCase(StringUtils.stripAccents(licensedName)
                .replaceAll("[^a-zA-Z0-9]", " ")
                .replaceAll("(\\d)([A-Za-z])", "$1 $2"));
        String accountEnvironment = DigestUtils.md5Hex(serverUrl).substring(0, 6);
        return accountName + "_" + accountEnvironment;
    }
}
