/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.events.FolderVariableCreatedEvent;
import com.xebialabs.xlrelease.domain.events.FolderVariableDeletedEvent;
import com.xebialabs.xlrelease.domain.events.FolderVariableUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.variables.FolderVariables;
import com.xebialabs.xlrelease.domain.variables.PasswordStringVariable;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.FolderVariableRepository;
import com.xebialabs.xlrelease.repository.IdMatchers;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils$;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005=b\u0001B\u0007\u000f\u0001]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006C\u00031\u0001\u0011\u0005\u0011\u0007C\u0003G\u0001\u0011\u0005q\tC\u0003h\u0001\u0011\u0005\u0001\u000eC\u0003m\u0001\u0011\u0005Q\u000eC\u0003u\u0001\u0011\u0005Q\u000fC\u0003y\u0001\u0011\u0005\u0011\u0010C\u0003}\u0001\u0011\u0005Q\u0010C\u0004\u0002\b\u0001!\t!!\u0003\t\u000f\u0005U\u0001\u0001\"\u0003\u0002\u0018\t)bi\u001c7eKJ4\u0016M]5bE2,7+\u001a:wS\u000e,'BA\b\u0011\u0003\u001d\u0019XM\u001d<jG\u0016T!!\u0005\n\u0002\u0013ad'/\u001a7fCN,'BA\n\u0015\u0003%AXMY5bY\u0006\u00147OC\u0001\u0016\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0001\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VMZ\u0001\u0011M>dG-\u001a:SKB|7/\u001b;pef\u0004\"\u0001I\u0012\u000e\u0003\u0005R!A\t\t\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002%C\t\u0001bi\u001c7eKJ\u0014V\r]8tSR|'/_\u0001\u0019M>dG-\u001a:WCJL\u0017M\u00197f%\u0016\u0004xn]5u_JL\bC\u0001\u0011(\u0013\tA\u0013E\u0001\rG_2$WM\u001d,be&\f'\r\\3SKB|7/\u001b;pef\f\u0001\"\u001a<f]R\u0014Uo\u001d\t\u0003W9j\u0011\u0001\f\u0006\u0003[A\ta!\u001a<f]R\u001c\u0018BA\u0018-\u0005EAFJU3mK\u0006\u001cX-\u0012<f]R\u0014Uo]\u0001\u0007y%t\u0017\u000e\u001e \u0015\tI\"TG\u000e\t\u0003g\u0001i\u0011A\u0004\u0005\u0006=\u0011\u0001\ra\b\u0005\u0006K\u0011\u0001\rA\n\u0005\u0006S\u0011\u0001\rA\u000b\u0015\u0003\ta\u0002\"!\u000f#\u000e\u0003iR!a\u000f\u001f\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002>}\u00059a-Y2u_JL(BA A\u0003\u0015\u0011W-\u00198t\u0015\t\t%)A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005\u0019\u0015aA8sO&\u0011QI\u000f\u0002\n\u0003V$xn^5sK\u0012\f\u0001BZ5oI\nK\u0018\n\u001a\u000b\u0003\u0011B\u0003\"!\u0013(\u000e\u0003)S!a\u0013'\u0002\u0013Y\f'/[1cY\u0016\u001c(BA'\u0011\u0003\u0019!w.\\1j]&\u0011qJ\u0013\u0002\t-\u0006\u0014\u0018.\u00192mK\")\u0011+\u0002a\u0001%\u0006Qa/\u0019:jC\ndW-\u00133\u0011\u0005MSfB\u0001+Y!\t)&$D\u0001W\u0015\t9f#\u0001\u0004=e>|GOP\u0005\u00033j\ta\u0001\u0015:fI\u00164\u0017BA.]\u0005\u0019\u0019FO]5oO*\u0011\u0011L\u0007\u0015\u0003\u000by\u0003\"aX3\u000e\u0003\u0001T!aO1\u000b\u0005\t\u001c\u0017aB7fiJL7m\u001d\u0006\u0003IR\t\u0001bY8eC\"\fG.Z\u0005\u0003M\u0002\u0014Q\u0001V5nK\u0012\fAc\u0019:fCR,gi\u001c7eKJ4\u0016M]5bE2,GC\u0001%j\u0011\u0015Qg\u00011\u0001I\u0003!1\u0018M]5bE2,\u0007F\u0001\u0004_\u0003e9W\r^!mY\u001a\u0013x.\\%n[\u0016$\u0017.\u0019;f!\u0006\u0014XM\u001c;\u0015\u00059\f\bCA%p\u0013\t\u0001(JA\bG_2$WM\u001d,be&\f'\r\\3t\u0011\u0015\u0011x\u00011\u0001S\u0003A1\u0018M]5bE2,\u0007+\u0019:f]RLE\r\u000b\u0002\b=\u0006\u0011r-\u001a;BY24%o\\7B]\u000e,7\u000f\u001e:z)\tqg\u000fC\u0003s\u0011\u0001\u0007!\u000b\u000b\u0002\t=\u0006!R\u000f\u001d3bi\u00164u\u000e\u001c3feZ\u000b'/[1cY\u0016$\"\u0001\u0013>\t\u000b)L\u0001\u0019\u0001%)\u0005%q\u0016\u0001\u00063fY\u0016$XMR8mI\u0016\u0014h+\u0019:jC\ndW\rF\u0002\u007f\u0003\u0007\u0001\"!G@\n\u0007\u0005\u0005!D\u0001\u0003V]&$\b\"B)\u000b\u0001\u0004\u0011\u0006F\u0001\u0006_\u0003%1\u0017N\u001c3Cs.+\u0017\u0010F\u0003I\u0003\u0017\ty\u0001\u0003\u0004\u0002\u000e-\u0001\rAU\u0001\fm\u0006\u0014\u0018.\u00192mK.+\u0017\u0010\u0003\u0004\u0002\u0012-\u0001\rAU\u0001\u0011m\u0006\u0014\u0018.\u00192mK\"{G\u000eZ3s\u0013\u0012D#a\u00030\u0002\u001b\rDWmY6TC6,G+\u001f9f)\u0015q\u0018\u0011DA\u000f\u0011\u0019\tY\u0002\u0004a\u0001\u0011\u000691-\u001e:sK:$\bBBA\u0010\u0019\u0001\u0007\u0001*A\u0004va\u0012\fG/\u001a3)\u0007\u0001\t\u0019\u0003\u0005\u0003\u0002&\u0005-RBAA\u0014\u0015\r\tI\u0003Q\u0001\u000bgR,'/Z8usB,\u0017\u0002BA\u0017\u0003O\u0011qaU3sm&\u001cW\r")
public class FolderVariableService {
    private final FolderRepository folderRepository;
    private final FolderVariableRepository folderVariableRepository;
    private final XLReleaseEventBus eventBus;

    @Timed
    public Variable findById(String variableId) {
        return this.folderVariableRepository.findById(variableId);
    }

    @Timed
    public Variable createFolderVariable(Variable variable) {
        Option option;
        String string = variable.getFolderId();
        if (string == null || (option = IdMatchers.FolderId$.MODULE$.unapply(string)).isEmpty()) {
            throw new Checks.IncorrectArgumentException("You can't add variable with id='" + string + "'", new Object[0]);
        }
        String folderId = (String)option.get();
        Checks.checkArgument((boolean)this.folderRepository.exists(folderId), (String)("Folder with id='" + folderId + "' doesn't exist"), (Object[])new Object[0]);
        variable.checkFolderVariableValidity();
        if (variable.isPassword()) {
            ((PasswordStringVariable)variable).checkExternalPasswordVariable();
        }
        PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option<ConfigurationItem>)None$.MODULE$, (ConfigurationItem)variable);
        Variable created = this.folderVariableRepository.create(variable);
        this.eventBus.publish((XLReleaseEvent)new FolderVariableCreatedEvent(created, null));
        return created;
    }

    @Timed
    public FolderVariables getAllFromImmediateParent(String variableParentId) {
        return new FolderVariables(variableParentId, this.folderVariableRepository.getAllFromParent(variableParentId));
    }

    @Timed
    public FolderVariables getAllFromAncestry(String variableParentId) {
        return new FolderVariables(variableParentId, this.folderVariableRepository.getAllFromAncestry(variableParentId));
    }

    @Timed
    public Variable updateFolderVariable(Variable variable) {
        variable.checkFolderVariableValidity();
        Variable current = this.folderVariableRepository.findById(variable.getId());
        this.checkSameType(current, variable);
        String string = current.getFolderId();
        String string2 = variable.getFolderId();
        Checks.checkArgument((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0, (String)"Cannot change folderId", (Object[])new Object[0]);
        if (variable.isPassword()) {
            ((PasswordStringVariable)variable).checkExternalPasswordVariable();
        }
        PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option<ConfigurationItem>)new Some((Object)current), (ConfigurationItem)variable);
        if (variable.getValueProvider() != null) {
            variable.getValueProvider().setVariable(variable);
        }
        Variable updated = this.folderVariableRepository.update(variable);
        this.eventBus.publish((XLReleaseEvent)new FolderVariableUpdatedEvent(variable, updated, null));
        return updated;
    }

    @Timed
    public void deleteFolderVariable(String variableId) {
        Variable variable = this.findById(variableId);
        this.folderVariableRepository.delete(variableId);
        this.eventBus.publish((XLReleaseEvent)new FolderVariableDeletedEvent(variable, null));
    }

    @Timed
    public Variable findByKey(String variableKey, String variableHolderId) {
        return this.folderVariableRepository.findByKey(variableKey, variableHolderId);
    }

    private void checkSameType(Variable current, Variable updated) {
        if (!current.getType().equals((Object)updated.getType())) {
            throw new IllegalArgumentException("Cannot change type of variable " + updated.getId() + " from " + current.getType() + " to " + updated.getType());
        }
    }

    @Autowired
    public FolderVariableService(FolderRepository folderRepository, FolderVariableRepository folderVariableRepository, XLReleaseEventBus eventBus) {
        this.folderRepository = folderRepository;
        this.folderVariableRepository = folderVariableRepository;
        this.eventBus = eventBus;
    }
}

