/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.param.IdParam;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.CommentView;
import com.xebialabs.xlrelease.views.converters.CommentViewConverter;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/comments")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class CommentResource {
    private final CommentService commentService;
    private final TaskRepository taskRepository;
    private final PermissionChecker permissions;
    private final CommentViewConverter commentViewConverter;

    @Autowired
    public CommentResource(CommentService commentService, TaskRepository taskRepository, PermissionChecker permissions, CommentViewConverter commentViewConverter) {
        this.commentService = commentService;
        this.taskRepository = taskRepository;
        this.permissions = permissions;
        this.commentViewConverter = commentViewConverter;
    }

    @PUT
    @Timed
    @Path(value="{commentId}")
    public CommentView updateComment(@PathParam(value="commentId") @IdParam String commentId, CommentView commentView) {
        String taskId = Ids.getParentId((String)commentId);
        this.permissions.checkIsAllowedToCommentOnTask(taskId);
        String releaseId = Ids.releaseIdFrom((String)taskId);
        if (this.permissions.canEditTask(releaseId) || commentView.getAuthor().getUsername().equalsIgnoreCase(User.AUTHENTICATED_USER.getName())) {
            Object task = this.taskRepository.findById(taskId, ResolveOptions.WITH_DECORATORS());
            Comment comment = this.commentService.update((Task)task, commentId, commentView.getText());
            return this.commentViewConverter.toFullView(comment);
        }
        throw PermissionDeniedException.withMessage((String)String.format("You cannot comment on task [%s]", taskId));
    }

    @DELETE
    @Timed
    @Path(value="{commentId}")
    public void deleteComment(@PathParam(value="commentId") @IdParam String commentId, CommentView commentView) {
        String taskId = Ids.getParentId((String)commentId);
        this.permissions.checkIsAllowedToCommentOnTask(taskId);
        String releaseId = Ids.releaseIdFrom((String)taskId);
        if (!this.permissions.canEditTask(releaseId) && !commentView.getAuthor().getUsername().equalsIgnoreCase(User.AUTHENTICATED_USER.getName())) {
            throw PermissionDeniedException.withMessage((String)String.format("You cannot delete comment on task [%s]", taskId));
        }
        Object task = this.taskRepository.findById(taskId, ResolveOptions.WITH_DECORATORS());
        this.commentService.delete((Task)task, commentId);
    }
}

