package com.xebialabs.xlrelease.scheduler.workers

import com.xebialabs.xlrelease.actors.ReleaseActorService
import com.xebialabs.xlrelease.domain.ScriptTask.JYTHON_ENGINE
import com.xebialabs.xlrelease.scheduler.PreconditionJob
import com.xebialabs.xlrelease.scheduler.workers.Worker.ExecuteJob
import com.xebialabs.xlrelease.script._
import org.springframework.stereotype.Component

@Component
class PreconditionWorker(releaseActorService: ReleaseActorService,
                         val scriptServicesList: java.util.List[ScriptService]
                        ) extends Worker with ScriptServiceSupport {
  override def execute: ExecuteJob = {
    case PreconditionJob(taskRef) =>
      val task = taskRef.get()
      val r: PreconditionResult = scriptServices.get(JYTHON_ENGINE).executePrecondition(task)
      r match {
        case ValidPreconditionResult(taskId, executionId, executionLog, attachmentId, authentication) =>
          withAuthentication(authentication) {
            releaseActorService.taskPreconditionValidated(taskId, executionId)
          }
        case ExceptionPreconditionResult(taskId, executionId, executionLog, attachmentId, authentication) =>
          withAuthentication(authentication) {
            releaseActorService.failScriptTask(taskId, executionLog, executionId, attachmentId, None)
          }
        case InvalidPreconditionResult(taskId, executionId, executionLog, attachmentId, authentication) =>
          withAuthentication(authentication) {
            releaseActorService.skipTaskDueToPreconditionCheck(taskId, executionId, executionLog)
          }
      }
  }

}
