package com.xebialabs.xlrelease;

import java.io.PrintStream;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

/**
 */
public class XLReleaseServerLaunchOptions {

    @Option(name = "-setup", usage = "(Re-)run the setup", required = false)
    private boolean doSetup = false;

    @Option(name = "-reinitialize", usage = "Reinitialize the repository, only useful with -setup", required = false)
    private boolean reinitialize = false;

    @Option(name = "-force", required = false)
    private boolean force;

    @Option(name = "-force-upgrades", required = false, usage = "Force execution of upgrades at startup")
    private boolean forceUpgrades;

    @Option(name = "-setup-defaults", required = false, usage = "Use the given file for defaults during setup")
    private String defaultsFile;

    @Option(name = "-repository-keystore-password", required = false, usage = "The password to open the repository-keystore.jceks file, if not given, the server will prompt you.")
    private String repositoryKeystorePassword;

    @Option(name = "-help", required = false, usage = "Prints this usage message")
    private boolean printUsage = false;

    @Option(name = "-force-remove-missing-types", usage = "Force removal of missing type definitions and ci references at startup.")
    private boolean forceRemoveMissingTypes;

    @Option(name = "-previous-installation", required = false, usage = "Path to previous Digital.ai Release installation to copy the data when doing an upgrade.")
    private String previousInstallation;

    @Option(name = "-plugin-source", usage = "Defines where the plugins will be loaded from. Allowed values: " +
            "'filesystem', 'database'. Defaults to 'database' if not specified")
    private String pluginSource;

    private static volatile XLReleaseServerLaunchOptions instance;

    public boolean isDoSetup() {
        return doSetup;
    }

    public void setDoSetup(final boolean doSetup) {
        this.doSetup = doSetup;
    }

    public boolean isReinitialize() {
        return reinitialize;
    }

    public void setReinitialize(final boolean reinitialize) {
        this.reinitialize = reinitialize;
    }

    public boolean isForce() {
        return force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean isForceUpgrades() {
        return forceUpgrades;
    }

    public void setForceUpgrades(boolean forceUpgrades) {
        this.forceUpgrades = forceUpgrades;
    }

    public boolean isPrintUsage() {
        return printUsage;
    }

    public void setPrintUsage(boolean printUsage) {
        this.printUsage = printUsage;
    }

    public String getDefaultsFile() {
        return defaultsFile;
    }

    public void setDefaultsFile(String defaultsFile) {
        this.defaultsFile = defaultsFile;
    }

    public String getRepositoryKeystorePassword() {
        return repositoryKeystorePassword;
    }

    public void setRepositoryKeystorePassword(final String repositoryKeystorePassword) {
        this.repositoryKeystorePassword = repositoryKeystorePassword;
    }

    public boolean isForceRemoveMissingTypes() {
        return forceRemoveMissingTypes;
    }

    public void setForceRemoveMissingTypes(final boolean forceRemoveMissingTypes) {
        this.forceRemoveMissingTypes = forceRemoveMissingTypes;
    }

    public String getPreviousInstallation() {
        return previousInstallation;
    }

    public void setPreviousInstallation(final String previousInstallation) {
        this.previousInstallation = previousInstallation;
    }

    public String getPluginSource() {
        return pluginSource;
    }

    public void setPluginSource(String pluginSource) {
        this.pluginSource = pluginSource;
    }

    public static XLReleaseServerLaunchOptions parseCommandLine(String[] args) {
        XLReleaseServerLaunchOptions options = new XLReleaseServerLaunchOptions();
        final CmdLineParser parser = new CmdLineParser(options);
        try {
            parser.parseArgument(args);
            if (options.isPrintUsage()) {
                printUsage(parser, System.out);
                return null;
            }
        } catch (CmdLineException e) {
            System.err.println(e.getMessage());
            printUsage(parser, System.err);
            return null;
        }
        return options;
    }

    private static void printUsage(CmdLineParser parser, PrintStream stream) {
        stream.println("Supported options:");
        parser.printUsage(stream);
    }

    public static XLReleaseServerLaunchOptions getInstance() {
        return instance;
    }

    public static void setInstance(XLReleaseServerLaunchOptions launchOptions) {
        XLReleaseServerLaunchOptions.instance = launchOptions;
    }

}
