package com.xebialabs.deployit.plumbing;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.*;

public class RequestLocal implements Filter {

    private static ThreadLocal<Map<Object, Object>> localMap = new ThreadLocal<Map<Object,Object>>();

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            initMap();
            chain.doFilter(request, response);
        } finally {
            removeMap();
        }
    }

    public static void removeMap() {
        localMap.remove();
    }

    public static void initMap() {
        localMap.set(new HashMap<Object,Object>());
    }

    @Override
    public void destroy() {
    }

    public static Map<Object, Object> getMap() {
        return localMap.get();
    }

}
