package com.xebialabs.xlrelease.db

import grizzled.slf4j.Logging
import liquibase.snapshot.SnapshotGeneratorFactory

import javax.sql.DataSource

class XLReleaseDbInitializer(val dbConfig: String, val dataSource: DataSource) extends LiquibaseSupport with Logging {

  def init(): Unit = {
    doWithLiquibase(dbConfig) { liquibase =>
      liquibase.update("")
    }
  }

  def isInitialized: Boolean = {
    doWithLiquibase(dbConfig) { liquibase =>
      SnapshotGeneratorFactory.getInstance().hasDatabaseChangeLogTable(liquibase.getDatabase)
    }
  }

}
