/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.tasks.container;

import com.xebialabs.xlrelease.domain.ContainerTask;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.tasks.TaskExecutor;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.scheduler.ContainerTaskJob;
import com.xebialabs.xlrelease.scheduler.WorkManager;
import com.xebialabs.xlrelease.script.TaskSoftReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContainerTaskExecutor
implements TaskExecutor<ContainerTask> {
    private WorkManager workManager;
    private TaskRepository taskRepository;

    @Autowired
    public ContainerTaskExecutor(WorkManager workManager, TaskRepository taskRepository) {
        this.workManager = workManager;
        this.taskRepository = taskRepository;
    }

    @Override
    public Class<ContainerTask> getTaskClass() {
        return ContainerTask.class;
    }

    @Override
    public void execute(TaskSoftReference<ContainerTask> taskRef) {
        if (!this.isAbortScriptInProgress(taskRef.getTaskId())) {
            this.workManager.submit(new ContainerTaskJob(taskRef));
        }
    }

    private boolean isAbortScriptInProgress(String taskId) {
        return this.taskRepository.getStatus(taskId) == TaskStatus.ABORT_SCRIPT_IN_PROGRESS;
    }
}

