package com.xebialabs.xlrelease.domain.tasks.container;

import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.repository.TaskRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.domain.ContainerTask;
import com.xebialabs.xlrelease.domain.tasks.TaskExecutor;
import com.xebialabs.xlrelease.scheduler.ContainerTaskJob;
import com.xebialabs.xlrelease.scheduler.WorkManager;
import com.xebialabs.xlrelease.script.TaskSoftReference;

@Component
public class ContainerTaskExecutor implements TaskExecutor<ContainerTask> {
    private WorkManager workManager;
    private TaskRepository taskRepository;

    @Autowired
    public ContainerTaskExecutor(WorkManager workManager, TaskRepository taskRepository) {
        this.workManager = workManager;
        this.taskRepository = taskRepository;
    }

    @Override
    public Class<ContainerTask> getTaskClass() {
        return ContainerTask.class;
    }

    @Override
    public void execute(TaskSoftReference<ContainerTask> taskRef) {
        if (isAbortScriptInProgress(taskRef.getTaskId())) {
            // abort command is already issued by workManager to the runner at this point
        } else {
            workManager.submit(new ContainerTaskJob(taskRef));
        }
    }

    private boolean isAbortScriptInProgress(String taskId) {
        return taskRepository.getStatus(taskId) == TaskStatus.ABORT_SCRIPT_IN_PROGRESS;
    }
}
