package com.xebialabs.xlrelease.actors.kryoserializers

import com.esotericsoftware.kryo.Kryo
import de.javakaffee.kryoserializers.guava.ImmutableListSerializer
import de.javakaffee.kryoserializers.{GregorianCalendarSerializer, SynchronizedCollectionsSerializer, UnmodifiableCollectionsSerializer}

import java.util.GregorianCalendar

// magro / javakaffe / kryo-serializers:
object JavaKaffeeSerializers extends Registrar {
  override def apply(implicit kryo: Kryo): Unit = {
    UnmodifiableCollectionsSerializer.registerSerializers(kryo)
    SynchronizedCollectionsSerializer.registerSerializers(kryo)
    kryo.register(classOf[GregorianCalendar], new GregorianCalendarSerializer())
    ImmutableListSerializer.registerSerializers(kryo)
  }
}
