package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.domain.UserProfile

import java.util.{Date, List => JList}
import scala.jdk.CollectionConverters._

trait UserProfileRepository {

  def create(userProfile: UserProfile): Unit

  def update(userProfile: JList[UserProfile]): Unit

  def updateLastActive(canonicalId: String, lastActive: Date): Boolean

  def updateLastActiveBatch(entries: Map[String, Date]): Int

  def updateLastActiveBatch(entries: java.util.Map[String, Date]): Int =
    updateLastActiveBatch(entries.asScala.toMap)

  def delete(userProfileId: String): Unit

  def findById(canonicalId: String): Option[UserProfile]

  def findAll(fullProfile: Boolean = false): JList[UserProfile]

  def exists(canonicalId: String): Boolean

  def customSearch(email: String, fullName: String, loginAllowed: java.lang.Boolean,
                   lastActiveAfter: Date, lastActiveBefore: Date,
                   page: Option[Long], resultsPerPage: Option[Long]): JList[UserProfile]

  def countUserWithLoginAllowed(): Int

}
