package com.xebialabs.xlrelease.events.handlers

import com.xebialabs.xlrelease.domain.distributed.events._
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.{AsyncSubscribe, EventListener}
import com.xebialabs.xlrelease.service.BroadcastService
import org.springframework.stereotype.Component

@Component
@EventListener
class DistributedEventAdapter(broadcastService: BroadcastService) {

  @AsyncSubscribe
  def onEvent(event: XLReleaseEvent): Unit = {
    val clusterEvent: Option[DistributedXLReleaseEvent] = event match {
      case _: DistributedXLReleaseEvent =>
        // do nothing, already cluster friendly event managed by broadcastService itself
        // handle here first specifically so nobody else tries to be clever
        None
      case e: CommentCreatedEvent =>
        Some(DistributedCommentCreatedEvent(e.task.getId, e.comment.getId))
      case e: CommentUpdatedEvent =>
        Some(DistributedCommentUpdatedEvent(e.task.getId, e.updated.getId))
      case e: CommentDeletedEvent =>
        Some(DistributedCommentDeletedEvent(e.task.getId, e.comment.getId))
      case e: AttachmentCreatedEvent =>
        Some(DistributedAttachmentCreatedEvent(e.containerId, e.attachment.getId))
      case e: AttachmentDeletedEvent =>
        Some(DistributedAttachmentDeletedEvent(e.containerId, e.attachment.getId))
      case e: TaskStatusLineUpdated =>
        Some(DistributedTaskStatusLineUpdated(e.taskId, e.statusLine))
      case _ =>
        None
    }
    clusterEvent.foreach(e => broadcastService.broadcast(e, publishEventOnSelf = true))
  }

}
