package com.xebialabs.xlrelease.actors

import com.twitter.chill.AllScalaRegistrar
import com.twitter.chill.java.PackageRegistrar
import com.xebialabs.xlplatform.utils.ClassLoaderUtils.classLoader
import com.xebialabs.xlrelease.actors.kryoserializers._
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException
import com.xebialabs.xlrelease.repository.proxy.ResolvableLazyConfigurationItem
import com.xebialabs.xlrelease.script.TaskSoftReference
import de.javakaffee.kryoserializers.guava.ImmutableListSerializer
import de.javakaffee.kryoserializers.{GregorianCalendarSerializer, SynchronizedCollectionsSerializer, UnmodifiableCollectionsSerializer}
import io.altoo.akka.serialization.kryo.DefaultKryoInitializer
import io.altoo.akka.serialization.kryo.serializer.scala._

import java.util.GregorianCalendar
import scala.collection.mutable
import scala.jdk.CollectionConverters._

class KryoInit extends DefaultKryoInitializer {

  override def postInit(kryo: ScalaKryo): Unit = {
    UnmodifiableCollectionsSerializer.registerSerializers(kryo)
    SynchronizedCollectionsSerializer.registerSerializers(kryo)

    PackageRegistrar.all().apply(kryo)

    kryo.register(classOf[GregorianCalendar], new GregorianCalendarSerializer())
    ImmutableListSerializer.registerSerializers(kryo)

    def useField[T](cls: Class[T]): Unit = { // useField method comes from chill library
      val fs = new com.esotericsoftware.kryo.serializers.FieldSerializer(kryo, cls)
      fs.setIgnoreSyntheticFields(false) // scala generates a lot of these attributes
      kryo.register(cls, fs)
    }

    // The wrappers are private classes:
    useField(Set(1, 2, 3).asJava.getClass)
    useField(mutable.Set(1, 2, 3).asJava.getClass)
    useField(Set(1, 2, 3).iterator.asJava.getClass)
    useField(mutable.Buffer(1, 2, 3).asJava.getClass)
    useField(mutable.Buffer(1, 2, 3).iterator.asJava.getClass)
    useField(mutable.Map("k" -> "v").asJava.getClass)

    kryo.register(classOf[LogFriendlyNotFoundException], LogFriendlyNotFoundExceptionSerializer)
    kryo.addDefaultSerializer(classOf[ResolvableLazyConfigurationItem], ResolvableLazyConfigurationItemSerializer)
    kryo.addDefaultSerializer(classOf[TaskSoftReference[_]], TaskSoftReferenceSerializer)

    new AllScalaRegistrar().apply(kryo)

    kryo.setClassLoader(classLoader) // this is wrong in so many ways I cannot even explain it to you if you don't get it
  }
}
