/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.user.User;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001B\b\u0011\u0001eA\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005U!A\u0011\u0007\u0001BC\u0002\u0013\u0005!\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00034\u0011!A\u0004A!b\u0001\n\u0003I\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011\u0005\u0003!Q1A\u0005\u0002\tC\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\u0006\u0015\u0002!\ta\u0013\u0005\bA\u0002\u0011\r\u0011\"\u0003b\u0011\u0019i\u0007\u0001)A\u0005E\")a\u000e\u0001C\u0001_\")1\u000f\u0001C\u0005i\")a\u0010\u0001C\u0005\u007f\nA2\u000b^;dW\u001e\u000bG/\u001a#fi\u0016\u001cGo\u001c:TKJ4\u0018nY3\u000b\u0005E\u0011\u0012aB:feZL7-\u001a\u0006\u0003'Q\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005U1\u0012!\u0003=fE&\fG.\u00192t\u0015\u00059\u0012aA2p[\u000e\u00011c\u0001\u0001\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1\u0011I\\=SK\u001a\u0004\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\u000bMdg\r\u000e6\u000b\u0003\u0015\n\u0001b\u001a:jujdW\rZ\u0005\u0003O\t\u0012q\u0001T8hO&tw-A\u0005yYJ\u001cuN\u001c4jOV\t!\u0006\u0005\u0002,]5\tAF\u0003\u0002.%\u000511m\u001c8gS\u001eL!a\f\u0017\u0003\u0013ac'oQ8oM&<\u0017A\u0003=me\u000e{gNZ5hA\u0005q!/\u001a7fCN,7+\u001a:wS\u000e,W#A\u001a\u0011\u0005Q*T\"\u0001\t\n\u0005Y\u0002\"A\u0004*fY\u0016\f7/Z*feZL7-Z\u0001\u0010e\u0016dW-Y:f'\u0016\u0014h/[2fA\u0005\u0019\"/\u001a7fCN,\u0017i\u0019;peN+'O^5dKV\t!\b\u0005\u0002<}5\tAH\u0003\u0002>%\u00051\u0011m\u0019;peNL!a\u0010\u001f\u0003'I+G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0002)I,G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3!\u00039!\u0018m]6SKB|7/\u001b;pef,\u0012a\u0011\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\rJ\t!B]3q_NLGo\u001c:z\u0013\tAUI\u0001\bUCN\\'+\u001a9pg&$xN]=\u0002\u001fQ\f7o\u001b*fa>\u001c\u0018\u000e^8ss\u0002\na\u0001P5oSRtD#\u0002'N\u001d>\u0003\u0006C\u0001\u001b\u0001\u0011\u0015A\u0013\u00021\u0001+\u0011\u0015\t\u0014\u00021\u00014\u0011\u0015A\u0014\u00021\u0001;\u0011\u0015\t\u0015\u00021\u0001DQ\tI!\u000b\u0005\u0002T=6\tAK\u0003\u0002V-\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005]C\u0016a\u00024bGR|'/\u001f\u0006\u00033j\u000bQAY3b]NT!a\u0017/\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!X\u0001\u0004_J<\u0017BA0U\u0005%\tU\u000f^8xSJ,G-A\td_6\u0004H.\u001a;j_:\u001cu.\\7f]R,\u0012A\u0019\t\u0003G*t!\u0001\u001a5\u0011\u0005\u0015dR\"\u00014\u000b\u0005\u001dD\u0012A\u0002\u001fs_>$h(\u0003\u0002j9\u00051\u0001K]3eK\u001aL!a\u001b7\u0003\rM#(/\u001b8h\u0015\tIG$\u0001\nd_6\u0004H.\u001a;j_:\u001cu.\\7f]R\u0004\u0013a\u0001:v]R\t\u0001\u000f\u0005\u0002\u001cc&\u0011!\u000f\b\u0002\u0005+:LG/A\fgS:$\u0017J\u001c)s_\u001e\u0014Xm]:HCR,G+Y:lgR\tQ\u000fE\u0002ww\nt!a^=\u000f\u0005\u0015D\u0018\"A\u000f\n\u0005id\u0012a\u00029bG.\fw-Z\u0005\u0003yv\u00141aU3r\u0015\tQH$\u0001\u0007v]N$XoY6HCR,7\u000fF\u0002q\u0003\u0003Aa!a\u0001\u000f\u0001\u0004)\u0018!B4bi\u0016\u001c\bf\u0001\u0001\u0002\bA!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000ei\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t\t\"a\u0003\u0003\u000fM+'O^5dK\u0002")
public class StuckGateDetectorService
implements Logging {
    private final XlrConfig xlrConfig;
    private final ReleaseService releaseService;
    private final ReleaseActorService releaseActorService;
    private final TaskRepository taskRepository;
    private final String completionComment;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        StuckGateDetectorService stuckGateDetectorService = this;
        synchronized (stuckGateDetectorService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public XlrConfig xlrConfig() {
        return this.xlrConfig;
    }

    public ReleaseService releaseService() {
        return this.releaseService;
    }

    public ReleaseActorService releaseActorService() {
        return this.releaseActorService;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    private String completionComment() {
        return this.completionComment;
    }

    public void run() {
        this.unstuckGates(this.findInProgressGateTasks());
    }

    private Seq<String> findInProgressGateTasks() {
        return this.taskRepository().findTaskIdsByTaskTypeStatusAndStartDate(Type.valueOf(GateTask.class), TaskStatus.IN_PROGRESS, Date.from(Instant.now().minus(this.xlrConfig().features().gateActor().graceDuration().toMillis(), ChronoUnit.MILLIS)));
    }

    private void unstuckGates(Seq<String> gates) {
        this.logger().debug((Function0 & Serializable)() -> "Monitoring gates.size gate tasks");
        ResolveOptions resolveOptions = ResolveOptions$.MODULE$.WITHOUT_DECORATORS();
        Map gatesByRelease = gates.groupBy((Function1 & Serializable)gateId -> Ids.releaseIdFrom((String)gateId));
        this.logger().debug((Function0 & Serializable)() -> "Processing " + gatesByRelease.size() + " releases with gate tasks");
        gatesByRelease.foreach((Function1 & Serializable)x0$1 -> {
            StuckGateDetectorService.$anonfun$unstuckGates$4(this, resolveOptions, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$unstuckGates$6(StuckGateDetectorService $this, Release release$1, String gateId) {
        block3: {
            try {
                GateTask gateTask = (GateTask)release$1.getTask(gateId);
                $this.logger().debug((Function0 & Serializable)() -> "       status: " + gateTask.getStatus());
                $this.logger().debug((Function0 & Serializable)() -> "   conditions: " + CollectionConverters$.MODULE$.ListHasAsScala(gateTask.getConditions()).asScala().forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isChecked())));
                $this.logger().debug((Function0 & Serializable)() -> " dependencies: " + CollectionConverters$.MODULE$.ListHasAsScala(gateTask.getDependencies()).asScala().forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDone())));
                if ((CollectionConverters$.MODULE$.ListHasAsScala(gateTask.getConditions()).asScala().nonEmpty() || CollectionConverters$.MODULE$.ListHasAsScala(gateTask.getDependencies()).asScala().nonEmpty()) && CollectionConverters$.MODULE$.ListHasAsScala(gateTask.getConditions()).asScala().forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isChecked())) && CollectionConverters$.MODULE$.ListHasAsScala(gateTask.getDependencies()).asScala().forall((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isDone()))) {
                    $this.logger().info((Function0 & Serializable)() -> "Completing stuck gate " + gateId);
                    $this.releaseActorService().markTaskAsDone(TaskStatus.COMPLETED, gateId, $this.completionComment(), User.SYSTEM);
                    break block3;
                }
                $this.logger().debug((Function0 & Serializable)() -> "Conditions not met for " + gateId + " (in progress)");
            }
            catch (Exception e) {
                $this.logger().error((Function0 & Serializable)() -> "Unable to process task " + gateId, (Function0 & Serializable)() -> e);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$unstuckGates$4(StuckGateDetectorService $this, ResolveOptions resolveOptions$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            String releaseId = (String)tuple2._1();
            Seq gateTaskIds = (Seq)tuple2._2();
            try {
                $this.logger().debug((Function0 & Serializable)() -> "Loading " + releaseId);
                Release release = $this.releaseService().findById(releaseId, resolveOptions$1);
                gateTaskIds.foreach((Function1 & Serializable)gateId -> {
                    StuckGateDetectorService.$anonfun$unstuckGates$6($this, release, gateId);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Exception e) {
                $this.logger().error((Function0 & Serializable)() -> "Unable to porcess release " + releaseId, (Function0 & Serializable)() -> e);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Autowired
    public StuckGateDetectorService(XlrConfig xlrConfig, ReleaseService releaseService, ReleaseActorService releaseActorService, TaskRepository taskRepository) {
        this.xlrConfig = xlrConfig;
        this.releaseService = releaseService;
        this.releaseActorService = releaseActorService;
        this.taskRepository = taskRepository;
        Logging.$init$((Logging)this);
        this.completionComment = "Completed by StuckGateDetectorService";
    }
}

